/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.linked.perN.PersonalPerN;
import com.tann.dice.gameplay.trigger.personal.linked.perN.ns.PerN;
import com.tann.dice.gameplay.trigger.personal.linked.perN.ns.PerNHeroLevel;
import com.tann.dice.util.bsRandom.Checker;
import com.tann.dice.util.bsRandom.RandomCheck;
import com.tann.dice.util.bsRandom.Supplier;
import java.util.List;

public class PipeItemPerTier
extends PipeRegexNamed<Item> {
    static final PRNPart PREF = new PRNPref("pertier");

    public PipeItemPerTier() {
        super(PREF, ITEM);
    }

    @Override
    protected Item internalMake(String[] groups) {
        return this.make(ItemLib.byName(groups[0]));
    }

    protected Item make(Item src) {
        if (src.isMissingno() || !src.isMultiplable(true)) {
            return null;
        }
        float tier = TierUtils.fromModTier(ChoosableType.Item, TierUtils.itemModTier(src.getTier()) * 2.1f);
        TextureRegion tr = src.getImage();
        ItBill ib = new ItBill(Math.round(tier), PREF + src.getName(), tr);
        List<Personal> personalTriggers = src.getPersonalTriggers();
        PerNHeroLevel perN = new PerNHeroLevel();
        for (int i = 0; i < personalTriggers.size(); ++i) {
            Personal p = personalTriggers.get(i);
            if (!PipeItemPerTier.shouldMult(p)) {
                ib.trigger(p);
                continue;
            }
            ib.trigger(new PersonalPerN(p, (PerN)perN));
        }
        return ib.bItem();
    }

    public static boolean shouldMult(Trigger p) {
        return !p.metaOnly() && !p.skipMultiplable() && p.isMultiplable();
    }

    @Override
    public Item example() {
        return this.make(PipeItemPerTier.randomCheckedMultipliable(true));
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return false;
    }

    @Override
    public float getRarity(boolean wild) {
        return 0.1f;
    }

    @Override
    protected Item generateInternal(boolean wild) {
        return this.make(PipeItemPerTier.randomCheckedMultipliable(false));
    }

    public static Item randomCheckedMultipliable(final boolean liberal) {
        return RandomCheck.checkedRandom(new Supplier<Item>(){

            @Override
            public Item supply() {
                return ItemLib.random();
            }
        }, new Checker<Item>(){

            @Override
            public boolean check(Item item) {
                return item.isMultiplable(liberal);
            }
        }, ItemLib.byName("Leather Vest"));
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

