/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.keyword;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalAllEntities;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.util.Tann;

public class PipeModAllKeyword
extends PipeRegexNamed<Modifier> {
    private final boolean hero;

    public PipeModAllKeyword(boolean hero) {
        super(PipeModAllKeyword.getPref(hero), KEYWORD);
        this.hero = hero;
    }

    private static PRNPart getPref(boolean hero) {
        return new PRNPref(hero ? "hero" : "monster");
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        Keyword k = Keyword.byName(groups[0]);
        return this.make(k);
    }

    private Modifier make(Keyword k) {
        if (k == null || k.spellOnly()) {
            return null;
        }
        float tier = this.hero ? KUtils.getModTierAllHero(k) : KUtils.getModTierAllMonster(k);
        return new Modifier(tier, PipeModAllKeyword.getPref(this.hero) + k.getName(), new GlobalAllEntities(this.hero, new AffectSides(new AddKeyword(k))));
    }

    @Override
    public Modifier example() {
        return this.make(Tann.random(Keyword.values()));
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return !wild;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        Keyword[] vals = Keyword.values();
        int attempts = 20;
        for (int i = 0; i < 20; ++i) {
            Rarity r;
            Keyword k = Tann.random(vals);
            if (KUtils.getModTierAll(k, this.hero) == 0.0f || (r = KUtils.getRarity(k)) != null && !Tann.chance(r.getValue())) continue;
            return this.make(k);
        }
        return null;
    }

    @Override
    public float getRarity(boolean wild) {
        return 0.35f;
    }

    @Override
    public boolean showHigher() {
        return true;
    }

    @Override
    public boolean skipAPI() {
        return !this.hero;
    }
}

