/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.bill.MTBill;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.RenameUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSource;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.trigger.personal.weird.DescribeOnlyTrait;
import java.util.List;

public class DataSourceMonster
extends DataSource<MonsterType> {
    public DataSourceMonster() {
        super(PipeRegexNamed.MONSTER);
    }

    @Override
    public MonsterType combine(MonsterType monType, TextureAtlas.AtlasRegion ar, String realName) {
        MTBill bill = EntTypeUtils.copy(monType);
        bill.arOverride(ar);
        bill.name(realName);
        MonsterType result = bill.bEntType();
        return result;
    }

    @Override
    public MonsterType makeT(String name) {
        MonsterType ht = MonsterTypeLib.byName(name);
        if (ht.isMissingno()) {
            return null;
        }
        return ht;
    }

    @Override
    public MonsterType exampleBase() {
        return MonsterTypeLib.randomWithRarity();
    }

    @Override
    public TextureAtlas.AtlasRegion getImage(MonsterType heroType) {
        return heroType.portrait;
    }

    @Override
    public MonsterType upscale(MonsterType mt, int multN) {
        if (mt.getName(false).matches(".*x\\d.*")) {
            return null;
        }
        if (multN <= 1) {
            return mt;
        }
        int mult = multN;
        MTBill mtb = new MTBill(mt.size);
        String newName = "x" + mult + "." + mt.getName(false);
        mtb.name(newName);
        mtb.hp(mt.hp * mult);
        for (Trait t : mt.traits) {
            mtb.trait(t.copy());
        }
        EntSide[] transformedSides = new EntSide[6];
        for (int si = 0; si < 6; ++si) {
            EntSide src = mt.sides[si];
            Eff base = src.getBaseEffect();
            EntSide replace = base.hasValue() ? src.withValue(base.getValue() * mult) : src.copy();
            transformedSides[si] = replace;
        }
        mtb.arOverride(mt.portrait);
        mtb.sidesRaw(transformedSides);
        return mtb.bEntType();
    }

    @Override
    public MonsterType rename(MonsterType src, String rename, String realName) {
        if (src == null || src.isMissingno() || realName == null || realName.isEmpty() || rename == null || rename.isEmpty()) {
            return null;
        }
        return RenameUtils.make(src, realName, rename);
    }

    @Override
    public MonsterType document(MonsterType src, String documentation, String realName) {
        MTBill mtb = EntTypeUtils.copy(src);
        mtb.trait(new DescribeOnlyTrait(documentation));
        mtb.name(realName);
        return mtb.bEntType();
    }

    @Override
    public MonsterType retier(MonsterType monsterType, int newTier, String realName) {
        return null;
    }

    @Override
    public MonsterType makeIndexed(long val) {
        if (val < 0L) {
            return null;
        }
        List<MonsterType> all = MonsterTypeLib.getMasterCopy();
        if (val < (long)all.size()) {
            return all.get((int)val);
        }
        return null;
    }

    @Override
    public MonsterType renameUnderlying(MonsterType monsterType, String rename) {
        return ((MTBill)EntTypeUtils.copy(monsterType).name(rename)).bEntType();
    }

    public static int reverseIndex(MonsterType mt) {
        return MonsterTypeLib.getMasterCopy().indexOf(mt);
    }
}

