/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ConditionalRequirement;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.ui.HpGrid;

public class ParamCondition
implements ConditionalRequirement {
    final ParamConType pct;
    final int val;
    final boolean source;

    public boolean isSource() {
        return this.source;
    }

    public ParamCondition(ParamConType pct, int val, boolean source) {
        this.pct = pct;
        this.val = val;
        this.source = source;
    }

    public ParamCondition(ParamConType pct, int val) {
        this(pct, val, true);
    }

    @Override
    public boolean isValid(Snapshot s, EntState sourceState, EntState targetState, Eff eff) {
        EntState chk = this.source ? sourceState : targetState;
        switch (this.pct) {
            case ExactlyHp: {
                return chk.getHp() == this.val;
            }
            case OrMoreHp: {
                return chk.getHp() >= this.val;
            }
            case OrLessHp: {
                return chk.getHp() <= this.val;
            }
            case OrLessMaxHp: {
                return chk.getMaxHp() <= this.val;
            }
            case OrMoreMaxHp: {
                return chk.getMaxHp() >= this.val;
            }
            case ExactlyMaxHp: {
                return chk.getMaxHp() == this.val;
            }
        }
        throw new RuntimeException("unimp: " + (Object)((Object)this.pct));
    }

    @Override
    public boolean preCalculate() {
        return this.source;
    }

    @Override
    public String getInvalidString(Eff eff) {
        return null;
    }

    @Override
    public String describe(Eff eff) {
        switch (this.pct) {
            case OrMoreHp: {
                return "with " + this.val + " or more hp";
            }
            case OrLessHp: {
                return "with " + this.val + " or less hp";
            }
            case OrMoreMaxHp: {
                return "with " + this.val + " or more max hp";
            }
            case OrLessMaxHp: {
                return "with " + this.val + " or less max hp";
            }
            case ExactlyHp: {
                return "with exactly " + this.val + " hp";
            }
            case ExactlyMaxHp: {
                return "with exactly " + this.val + " max hp";
            }
        }
        return "unset: " + (Object)((Object)this.pct);
    }

    @Override
    public String getBasicString() {
        return this.describe(null);
    }

    @Override
    public Actor getRestrictionActor() {
        int next5 = (this.val + 5) / 5 * 5;
        switch (this.pct) {
            case ExactlyMaxHp: {
                return new Pixl().text("[grey]max[p][p]=").gap(2).actor(HpGrid.make(this.val, this.val)).pix();
            }
            case OrMoreMaxHp: {
                return new Pixl().text("[grey]max[n]>=").gap(2).actor(HpGrid.make(this.val, this.val)).pix();
            }
            case OrLessMaxHp: {
                return new Pixl().text("[grey]max[n]<=").gap(2).actor(HpGrid.make(this.val, this.val)).pix();
            }
            case ExactlyHp: {
                return HpGrid.make(this.val, next5);
            }
            case OrLessHp: {
                return new Pixl().image(Images.lte, Colours.text).gap(2).actor(HpGrid.make(this.val, next5)).pix();
            }
            case OrMoreHp: {
                return new Pixl().image(Images.ge, Colours.text).gap(2).actor(HpGrid.make(this.val, next5)).pix();
            }
        }
        return new Pixl().text("unimp: " + (Object)((Object)this.pct) + "/" + this.val).pix();
    }

    @Override
    public boolean isPlural() {
        return true;
    }

    public ParamCondition getSwapped() {
        return new ParamCondition(this.pct, this.val, !this.source);
    }

    public String hyphenTag() {
        return this.val + "";
    }

    public static enum ParamConType {
        ExactlyHp,
        OrMoreHp,
        OrMoreMaxHp,
        OrLessMaxHp,
        ExactlyMaxHp,
        OrLessHp;

    }
}

