/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability.tactic;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.TacticCostType;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TacticCost {
    final List<TacticCostType> costs;

    public TacticCost(List<TacticCostType> costs) {
        this.costs = costs;
    }

    public TacticCost(TacticCostType ... costs) {
        this(Arrays.asList(costs));
    }

    public TacticCost(TacticCostType t, int amt) {
        this(TacticCost.makeList(t, amt));
    }

    private static List<TacticCostType> makeList(TacticCostType t, int amt) {
        ArrayList<TacticCostType> result = new ArrayList<TacticCostType>();
        for (int i = 0; i < amt; ++i) {
            result.add(t);
        }
        return result;
    }

    public List<Actor> makeActors(Snapshot snapshot) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        List<TacticCostType> fulfilledCosts = this.getFulfilledCosts(snapshot);
        if (PhaseManager.get().getPhase() instanceof ChoicePhase) {
            fulfilledCosts.clear();
        }
        Map<TacticCostType, Integer> map = this.getCostAmtsUnwise();
        ArrayList<TacticCostType> ordered = new ArrayList<TacticCostType>(this.costs);
        Tann.uniquify(ordered);
        for (TacticCostType costType : ordered) {
            int amt = map.get((Object)costType);
            if (amt > 2) {
                boolean fulf = Tann.countInList(costType, fulfilledCosts) >= amt;
                result.add(new Pixl().actor(costType.getActor(fulf)).gap(-1).text("[text]x" + map.get((Object)costType)).pix());
                continue;
            }
            for (int i = 0; i < amt; ++i) {
                result.add(costType.getActor(fulfilledCosts.remove((Object)costType)));
            }
        }
        return result;
    }

    public boolean isUsable(Snapshot snapshot) {
        return this.getFulfilledCosts(snapshot).size() == this.costs.size();
    }

    public List<EntState> getHeroesWhoWantToBeUsedForTactic(Snapshot snapshot) {
        ArrayList<EntState> result = new ArrayList<EntState>();
        ArrayList<TacticCostType> cpy = new ArrayList<TacticCostType>(this.costs);
        for (EntState state : snapshot.getStates(true, false)) {
            EntSideState ess;
            if (state.isUsed() || (ess = state.getCurrentSideState()) == null) continue;
            Eff e = ess.getCalculatedEffect();
            List<TacticCostType> validTypes = TacticCostType.getValidTypes(e);
            boolean found = false;
            for (int i = 0; i < validTypes.size(); ++i) {
                TacticCostType v = validTypes.get(i);
                int amt = v.pippy && e.hasValue() ? e.getValue() : 1;
                for (int i1 = 0; i1 < amt; ++i1) {
                    found |= cpy.remove((Object)v);
                }
            }
            if (found) {
                result.add(state);
            }
            if (!cpy.isEmpty()) continue;
            return result;
        }
        return result;
    }

    private List<TacticCostType> getFulfilledCosts(Snapshot snapshot) {
        if (snapshot == null) {
            return new ArrayList<TacticCostType>();
        }
        List<EntState> heroes = this.getHeroesWhoWantToBeUsedForTactic(snapshot);
        ArrayList<TacticCostType> cpy = new ArrayList<TacticCostType>(this.costs);
        ArrayList<TacticCostType> fulfilled = new ArrayList<TacticCostType>();
        for (EntState state : heroes) {
            Eff e = state.getCurrentSideState().getCalculatedEffect();
            List<TacticCostType> validTypes = TacticCostType.getValidTypes(e);
            for (int i = 0; i < validTypes.size(); ++i) {
                int amt;
                TacticCostType v = validTypes.get(i);
                int n = amt = e.hasValue() && v.pippy ? e.getValue() : 1;
                if (e.hasKeyword(Keyword.tactical)) {
                    amt *= 2;
                }
                for (int i1 = 0; i1 < amt; ++i1) {
                    if (!cpy.remove((Object)v)) continue;
                    fulfilled.add(v);
                }
            }
        }
        return fulfilled;
    }

    public String describe() {
        int store = 0;
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < this.costs.size(); ++i) {
            TacticCostType costType = this.costs.get(i);
            if (i < this.costs.size() - 1 && this.costs.get(i + 1) == costType) {
                ++store;
                continue;
            }
            int thisAmt = 1 + store;
            store = 0;
            parts.add(costType.describe(thisAmt));
        }
        return Tann.commaList(parts);
    }

    public Map<TacticCostType, Integer> getCostAmtsUnwise() {
        HashMap<TacticCostType, Integer> result = new HashMap<TacticCostType, Integer>();
        for (TacticCostType cost : this.costs) {
            if (result.get((Object)cost) == null) {
                result.put(cost, 0);
            }
            result.put(cost, (Integer)result.get((Object)cost) + 1);
        }
        return result;
    }
}

