/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellUtils;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.gameplay.effect.targetable.ability.ui.AbilityActor;
import com.tann.dice.gameplay.effect.targetable.ability.ui.ManaHolder;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.listener.SnapshotChangeListener;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.TargetingManager;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TextWisp;
import com.tann.dice.util.listener.MultitapListener;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.action.PixAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AbilityHolder
extends Group
implements SnapshotChangeListener {
    ManaHolder manaHolder;
    List<AbilityActor> abilityActors = new ArrayList<AbilityActor>();
    Snapshot present;
    Snapshot visual;
    static Comparator<AbilityActor> comp = new Comparator<AbilityActor>(){

        @Override
        public int compare(AbilityActor o1, AbilityActor o2) {
            Ability a1 = o1.ability;
            Ability a2 = o2.ability;
            boolean o1Burst = a1.getTitle().equalsIgnoreCase("Burst");
            boolean o2Burst = a2.getTitle().equalsIgnoreCase("Burst");
            if (o1Burst) {
                return -1;
            }
            if (o2Burst) {
                return 1;
            }
            boolean o1Spell = a1 instanceof Spell;
            boolean o2Spell = a2 instanceof Spell;
            if (o1Spell != o2Spell) {
                return o1Spell ? 1 : -1;
            }
            if (o1Spell && o2Spell) {
                return ((Spell)a1).getBaseCost() - ((Spell)a2).getBaseCost();
            }
            return a1.getTitle().compareTo(a2.getTitle());
        }
    };
    TuckState tuckState = TuckState.OnScreen;

    public AbilityHolder(int width, FightLog fightLog) {
        this.setTransform(false);
        this.present = fightLog.getSnapshot(FightLog.Temporality.Present);
        this.visual = fightLog.getSnapshot(FightLog.Temporality.Visual);
        fightLog.registerSnapshotListener(this, FightLog.Temporality.Present, FightLog.Temporality.Visual);
        this.setSize(width, DungeonScreen.getBottomButtonHeight());
        this.manaHolder = new ManaHolder(this.visual);
        this.addActor(this.manaHolder);
        this.updateManaholderPosition();
    }

    private void updateManaholderPosition() {
        this.manaHolder.setPosition((int)(this.getWidth() / 2.0f), this.getHeight() + 1.0f);
    }

    private void updateSpells() {
        boolean staggered;
        boolean port = Main.isPortrait();
        List<TP<Ability, Boolean>> spellMap = SpellUtils.getAvailableSpells(this.present);
        ArrayList<Ability> availableSpells = new ArrayList<Ability>();
        for (TP<Ability, Boolean> t : spellMap) {
            availableSpells.add((Ability)t.a);
        }
        for (int i = this.abilityActors.size() - 1; i >= 0; --i) {
            AbilityActor sa = this.abilityActors.get(i);
            if (availableSpells.contains(sa.ability)) continue;
            this.abilityActors.remove(sa);
            sa.addAction(Actions.sequence((Action)Actions.moveTo(sa.getX(), -sa.getHeight(), this.getSpd(), Chrono.i), (Action)Actions.removeActor()));
        }
        int spellsPerRow = availableSpells.size();
        boolean bl = staggered = port && availableSpells.size() > 3;
        if (staggered) {
            spellsPerRow = (int)Math.ceil((float)availableSpells.size() / 2.0f);
        }
        int cardWidth = (int)Math.min(48.0f, this.getWidth() / (float)spellsPerRow);
        boolean showText = true;
        for (final TP<Ability, Boolean> s : spellMap) {
            showText &= AbilityActor.canDisplay((Ability)s.a, cardWidth);
        }
        for (final TP<Ability, Boolean> s : spellMap) {
            boolean found = false;
            for (AbilityActor sa : this.abilityActors) {
                if (sa.ability != s.a) continue;
                sa.setDead((Boolean)s.b == false);
                sa.setPresentSnapshot(this.present);
                sa.setShowText(showText);
                found = true;
                break;
            }
            if (found) continue;
            AbilityActor sa = new AbilityActor((Ability)s.a, cardWidth, this.present);
            sa.setShowText(showText);
            this.abilityActors.add(sa);
            this.addActor(sa);
            sa.setDead((Boolean)s.b == false);
            sa.setPosition(-1.0f, -1.0f);
            sa.addListener(new MultitapListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    AbilityHolder.this.selectForCast((Ability)s.a);
                    return true;
                }

                @Override
                public boolean info(int button, float x, float y) {
                    AbilityHolder.this.selectForInfo((Ability)s.a);
                    return true;
                }
            });
        }
        Collections.sort(this.abilityActors, comp);
        List<AbilityActor> curr = this.abilityActors;
        float floatGap = (this.getWidth() - (float)(spellsPerRow * cardWidth)) / (float)(spellsPerRow + 1);
        int gap = (int)floatGap;
        int offset = Math.round(((floatGap - (float)gap) * (float)spellsPerRow - 1.0f) / 2.0f) + (port ? gap : gap);
        if (staggered) {
            int amtSecondRow = (int)Math.ceil((float)curr.size() / 2.0f);
            int amtFirstRow = curr.size() - amtSecondRow;
            for (int i = 0; i < curr.size(); ++i) {
                int targetY;
                int offsetI;
                AbilityActor sp = curr.get(i);
                sp.reset(cardWidth);
                boolean firstRow = (double)i < Math.ceil((float)curr.size() / 2.0f);
                int sOff = offset;
                int n = offsetI = !firstRow ? i - curr.size() / 2 : i;
                if (!firstRow && amtSecondRow != amtFirstRow) {
                    sOff = (int)(-sp.getWidth()) / 2;
                }
                int targetX = (int)((float)offsetI * ((float)gap + sp.getWidth())) + sOff;
                int n2 = targetY = !firstRow ? (int)sp.getHeight() : 0;
                if (sp.getX() == -1.0f && sp.getY() == -1.0f) {
                    sp.setPosition(targetX, -sp.getHeight());
                }
                sp.addAction(PixAction.moveTo(targetX, targetY, this.getSpd(), Chrono.i));
            }
        } else {
            for (int i = 0; i < curr.size(); ++i) {
                AbilityActor sp = curr.get(i);
                sp.reset(cardWidth);
                int targetX = (int)((float)i * ((float)gap + sp.getWidth())) + offset;
                if (sp.getX() == -1.0f && sp.getY() == -1.0f) {
                    sp.setPosition(targetX, -sp.getHeight());
                }
                sp.addAction(PixAction.moveTo(targetX, 0, this.getSpd(), Chrono.i));
            }
        }
        this.setHeight(29 * (staggered ? 2 : 1));
        this.updateManaholderPosition();
    }

    private boolean isAutoCast(Ability a) {
        return !a.getDerivedEffects().needsTarget() && PhaseManager.get().getPhase().canTarget();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void snapshotChanged(FightLog.Temporality temporality, Snapshot newSnapshot) {
        switch (temporality) {
            case Base: {
                break;
            }
            case Visual: {
                this.visual = newSnapshot;
                this.manaHolder.update(this.visual.getTotalMana(), this.visual.getMaxMana());
                break;
            }
            case Present: {
                this.present = newSnapshot;
                this.updateSpells();
                break;
            }
        }
    }

    public void heroDiceRolled() {
        this.updateSpells();
    }

    public void allDiceLanded() {
        this.updateSpells();
    }

    public void addWisp(String s) {
        this.addWisp(s, 1.1f);
    }

    public void addWisp(String s, float delay) {
        TextWisp tw = new TextWisp(s, 0, 0, 0.3f, delay);
        this.addActor(tw);
        int gap = 2;
        int y = 0;
        for (Actor a : this.getChildren()) {
            y = (int)Math.max((float)y, a.getY() + (float)gap);
        }
        tw.setPosition((int)(this.manaHolder.getX() - tw.getWidth() / 2.0f), y);
    }

    public Ability getByIndex(int index) {
        if (this.abilityActors.size() > index) {
            return this.abilityActors.get((int)index).ability;
        }
        return null;
    }

    public void selectForInfo(Ability ability) {
        TargetingManager tm = DungeonScreen.get().targetingManager;
        if (tm.getSelectedTargetable() == ability) {
            DungeonScreen.get().popSingleLight();
        }
        DungeonScreen.get().popAllLight();
        tm.showExplanelInactive(ability);
    }

    public void selectForCast(Ability ability) {
        if (!PhaseManager.get().getPhase().canTarget()) {
            this.selectForInfo(ability);
            return;
        }
        if (this.present.isEnd()) {
            return;
        }
        Boolean canCast = null;
        for (AbilityActor sa : this.abilityActors) {
            if (sa.ability != ability) continue;
            if (sa.isDead()) {
                canCast = false;
                break;
            }
            canCast = true;
            break;
        }
        if (canCast == null) {
            canCast = false;
            TannLog.log("Error finding spell in party: " + ability);
        }
        if (!canCast.booleanValue()) {
            Sounds.playSound(Sounds.error);
            AbilityHolder.showInfo("[red]Can't use abilities from defeated heroes", Colours.red);
            return;
        }
        TargetingManager tm = DungeonScreen.get().targetingManager;
        if (tm.getSelectedTargetable() == ability) {
            DungeonScreen.get().popSingleLight();
            Sounds.playSound(Sounds.pop);
            return;
        }
        DungeonScreen.get().popAllLight();
        if (!ability.isUsable(this.present)) {
            Sounds.playSound(Sounds.error);
            if (ability instanceof Spell) {
                AbilityHolder.showInfo("[red]Not enough [blue]mana", Colours.red);
            } else if (ability instanceof Tactic) {
                AbilityHolder.showInfo("[red]All costs must be present on unused dice", Colours.red);
            }
            return;
        }
        if (this.isAutoCast(ability)) {
            String invalidReason = tm.getInvalidTargetReason(null, ability, true);
            if (invalidReason == null) {
                tm.target(null, ability);
            } else {
                Sounds.playSound(Sounds.error);
                AbilityHolder.showInfo(invalidReason, Colours.red);
            }
        } else {
            tm.setSelectedTargetable(ability);
        }
    }

    private float getSpd() {
        return DungeonScreen.get().isLoading() ? 0.0f : 0.3f;
    }

    public void tuck(TuckState tuckState, boolean instant) {
        int toY;
        int toX = (int)this.getX();
        int n = toY = tuckState == TuckState.OffScreen ? (int)(-this.getHeight()) : 0;
        if (instant) {
            this.setPosition(toX, toY);
        } else {
            this.addAction(PixAction.moveTo(toX, toY, this.getSpd(), Chrono.i));
        }
        this.tuckState = tuckState;
    }

    public static void showInfo(String message, Color c) {
        TextWriter text = new TextWriter(message, 100, c, 3);
        float displayTime = 0.5f + text.getWidth() * text.getHeight() * 3.5E-4f;
        text.setTouchable(Touchable.disabled);
        Main.getCurrentScreen().addActor(text);
        text.setPosition((int)((float)(Main.width / 2) - text.getWidth() / 2.0f), -text.getHeight());
        text.addAction(Actions.sequence(PixAction.moveTo((int)text.getX(), 47, 0.3f, Interpolation.pow2Out), (Action)Actions.delay(displayTime), PixAction.moveTo((int)text.getX(), (int)(-text.getHeight()) - 10, 0.3f, Interpolation.pow2Out), (Action)Actions.removeActor()));
    }

    public static enum TuckState {
        OffScreen,
        Tucked,
        OnScreen;

    }
}

