/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.mode.creative.pastey;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.creative.pastey.PasteConfig;
import com.tann.dice.gameplay.mode.creative.pastey.Scenario;
import com.tann.dice.gameplay.mode.meta.folder.FolderType;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.gameplay.EnemyRollingPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPhase;
import com.tann.dice.gameplay.save.SaveState;
import com.tann.dice.gameplay.save.SaveStateData;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.ClipboardUtils;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PasteMode
extends Mode {
    public PasteMode() {
        super("Paste");
    }

    public static Actor makeEscButton() {
        StandardButton paste = new StandardButton("[pink]Copy");
        paste.setRunnable(new Runnable(){

            @Override
            public void run() {
                Phase p = PhaseManager.get().getPhase();
                if (!p.isPastey()) {
                    Sounds.playSound(Sounds.error);
                    Main.getCurrentScreen().showDialog("[red]wrong phase: " + p.getClass().getSimpleName(), Colours.pink);
                    return;
                }
                final boolean hasEnd = PhaseManager.get().has(LevelEndPhase.class);
                ChoiceDialog cd = new ChoiceDialog("Copy state to clipboard for " + Mode.PASTE.getName() + "?", hasEnd ? ChoiceDialog.ChoiceNames.YesCancel : ChoiceDialog.ChoiceNames.HackyStartNow, new Runnable(){

                    @Override
                    public void run() {
                        String tc = OptionLib.TINY_PASTE.c() ? DungeonScreen.get().tryTinyPaste() : DungeonScreen.get().reportStringSave(true);
                        PasteMode.escCopyString(tc);
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        if (hasEnd) {
                            Main.getCurrentScreen().popSingleMedium();
                        } else {
                            PasteMode.escCopyString(PasteMode.encloseBackticks(PasteMode.getStringFromStartOfLevel(DungeonScreen.get().getDungeonContext())));
                        }
                    }
                });
                Main.getCurrentScreen().push(cd);
                Tann.center(cd);
            }
        });
        return paste;
    }

    public static String encloseBackticks(String s) {
        return "`" + s + "`";
    }

    private static void escCopyString(String toClip) {
        ClipboardUtils.copyWithSoundAndToast(toClip);
        Main.getCurrentScreen().popAllMedium();
    }

    private static String getStringFromStartOfLevel(DungeonContext dc) {
        int numEntities = dc.getParty().getHeroes().size() + dc.getCurrentLevel().getMonsterList().size();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < numEntities; ++i) {
            l.add("0");
        }
        SaveStateData ssd = new SaveStateData(dc.toData(), new ArrayList<String>(), Tann.commaList(l, ",", ","), Arrays.asList(new LevelEndPhase().serialise(), new EnemyRollingPhase().serialise()));
        ssd.trimContextDataForReport();
        return ssd.toState().getSaveString();
    }

    public static String genericPasteTagHandleCleanup(String s) {
        if (Tann.countCharsInString('`', s = s.trim()) >= 2) {
            s = s.substring(s.indexOf("`") + 1, s.lastIndexOf("`"));
        }
        s = s.replaceAll("`", "");
        return PasteMode.removeNewlines(s);
    }

    public static String removeNewlines(String s) {
        return s.replaceAll("\\r|\\n", "");
    }

    @Override
    public Actor makeStartGameCard(List<ContextConfig> all) {
        Pixl p = new Pixl(3);
        StandardButton paste = new StandardButton("[pink]Paste!");
        paste.setRunnable(new Runnable(){

            @Override
            public void run() {
                Pipe.setupChecks();
                this.doInput();
                Pipe.disableChecks();
            }

            private void doInput() {
                String content = ClipboardUtils.pasteSafer();
                if (content != null && (content.startsWith("=") || !ModifierLib.byName(content).isMissingno())) {
                    Main.getCurrentScreen().showDialog(PasteMode.looksLikeFor(Mode.CUSTOM));
                    return;
                }
                PasteMode.attemptToStartFromString(content, new PasteConfig());
                PasteMode.this.specialPasteSave();
            }
        });
        StandardButton store = new StandardButton("[text]Store");
        store.setRunnable(new Runnable(){

            @Override
            public void run() {
                final String clip = ClipboardUtils.pasteSafer();
                try {
                    SaveState result = SaveState.loadPasteModeString(clip, true);
                    if (!result.validForPaste()) {
                        Main.getCurrentScreen().showDialog("invalid scenario paste");
                    } else {
                        Main.self().control.textInput(new Input.TextInputListener(){

                            @Override
                            public void input(String text) {
                                Main.getSettings().saveScenario(new Scenario(text, clip));
                                Main.self().setScreen(Main.getCurrentScreen().copy());
                                Main.getCurrentScreen().showDialog("scenario paste saved");
                            }

                            @Override
                            public void canceled() {
                                Main.getCurrentScreen().popAllMedium();
                            }
                        }, "Scenario title", "", "title");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Main.getCurrentScreen().showDialog("invalid scenario paste (error)");
                }
            }
        });
        p.actor(paste).actor(store).row(6);
        Pixl scen = new Pixl(1);
        for (final Scenario sc : this.getScenarios()) {
            StandardButton tb = new StandardButton(sc.getTitle());
            tb.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    PasteMode.attemptToStartFromString(sc.getContent(), new PasteConfig());
                    return true;
                }

                @Override
                public boolean info(int button, float x, float y) {
                    ChoiceDialog cd = new ChoiceDialog("Delete " + sc.getTitle() + "?", ChoiceDialog.ChoiceNames.YesCancel, new Runnable(){

                        @Override
                        public void run() {
                            boolean removed = Main.getSettings().deleteScenario(sc);
                            if (!removed) {
                                Main.getCurrentScreen().popAllMedium();
                                Main.getCurrentScreen().showDialog("Failed to delete", Colours.red);
                            } else {
                                Main.self().setScreen(Main.getCurrentScreen().copy());
                                Main.getCurrentScreen().showDialog("Deleted " + sc.getTitle(), Colours.green);
                            }
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            Main.getCurrentScreen().popAllMedium();
                        }
                    });
                    Main.getCurrentScreen().push(cd, 0.8f);
                    Tann.center(cd);
                    return true;
                }
            });
            scen.actor(tb, (int)((float)Main.width * 0.75f));
        }
        Group scenarios = scen.pix();
        ScrollPane sp = Tann.makeScrollpane(scenarios);
        sp.setWidth(scenarios.getWidth() + 6.0f);
        sp.setHeight(Math.min(40.0f, scenarios.getHeight() + 6.0f));
        p.row().actor(sp);
        Group loadButton = SaveState.getLoadButton(this.getConfigs().get(0).getGeneralSaveKey());
        if (loadButton != null) {
            p.row().actor(loadButton);
        }
        return p.pix();
    }

    private void specialPasteSave() {
        Screen s = Main.getCurrentScreen();
        if (s instanceof DungeonScreen) {
            DungeonScreen ds = (DungeonScreen)s;
            ds.save();
        }
    }

    private List<Scenario> getScenarios() {
        ArrayList<Scenario> all = new ArrayList<Scenario>(Main.getSettings().getScenarios());
        return all;
    }

    public static String getPasteErrorGeneric(String paste) {
        if (paste == null) {
            return "[red]Empty clipboard";
        }
        if (paste.length() > 300000) {
            return "[red]Clipboard too long[n][text](" + paste.length() + " characters!)";
        }
        String rep = paste.replaceAll("[a-zA-Z0-9#+=.,_ /'()@?%$&!~{}`;:|\\^\\\\\\[\\]\"\r\n\\-]", "");
        if (!rep.isEmpty()) {
            List<Character> chars = Tann.toCharList(rep);
            Tann.uniquify(chars);
            TannLog.error("illegal chars: " + chars.toString());
            TannLog.error("illegal string: " + paste);
            System.out.println(chars);
            return "[red]Illegal characters in clipboard: [cu]" + chars.toString().replaceAll("[\\[\\]]", "") + "[n][grey]Try an alternate text editor?";
        }
        return null;
    }

    public static String looksLikeFor(Mode m) {
        return "this is likely for " + m.getTextButtonName() + " mode";
    }

    @Override
    protected List<ContextConfig> makeAllConfigs() {
        return Arrays.asList(new PasteConfig());
    }

    @Override
    public String[] getDescriptionLines() {
        return new String[]{"paste a save from anywhere", "cog -> [pink]copy[cu] in any fight to copy"};
    }

    public static void attemptToStartFromString(String content, ContextConfig blankConfig) {
        String genericError = PasteMode.getPasteErrorGeneric(content);
        if (genericError != null) {
            Main.getCurrentScreen().showDialog(genericError);
            return;
        }
        try {
            SaveState result = SaveState.loadPasteModeString(content, blankConfig == null);
            if (!result.validForPaste()) {
                throw new Exception("wrong");
            }
            result.dungeonContext.setContextConfig(blankConfig);
            result.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (content == null) {
                content = "null";
            }
            String extra = "";
            extra = e.getMessage() != null ? ":[n][text]" + e.getMessage().substring(0, Math.min(e.getMessage().length(), 20)) + "..." : ":[n][text]" + e.getClass().getSimpleName();
            Main.getCurrentScreen().showDialog("Failed to load fight from clipboard" + extra, Colours.red);
        }
    }

    @Override
    public String getSaveKey() {
        return "paste";
    }

    @Override
    public boolean skipStats() {
        return true;
    }

    @Override
    protected String getExtraDescription() {
        return "You can copy a save state from most places using menu - system - copy. This is just text which can be pasted into this mode or shared online";
    }

    @Override
    public boolean skipShowBoss() {
        return true;
    }

    @Override
    public FolderType getFolderType() {
        return FolderType.creative;
    }
}

