/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier;

import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.ModifierPickContext;
import com.tann.dice.gameplay.modifier.PermStats;
import com.tann.dice.util.DebugUtilsUseful;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ModifierPickUtils {
    static final int safeguardMult = 7;

    public static List<Modifier> getModifiersAddingUpTo(int amt, int addUpTo, ModifierPickContext modifierPickContext, boolean wildcard, DungeonContext dc) {
        ArrayList<Modifier> avoid = new ArrayList<Modifier>(dc.getCurrentModifiers());
        avoid.addAll(dc.getAvoidModifiers());
        return ModifierPickUtils.getModifiersAddingUpTo(amt, addUpTo, modifierPickContext, wildcard, avoid, new ArrayList<Modifier>(), dc.getBannedCollisionBits());
    }

    private static List<Modifier> getModifiersAddingUpTo(int amt, int addUpTo, ModifierPickContext modifierPickContext, boolean wildcard, List<Modifier> avoid, List<Modifier> seen, long collisionBit) {
        int max;
        int min;
        if (avoid.size() > 10) {
            avoid = new ArrayList<Modifier>();
        }
        ArrayList<List<Modifier>> modLists = new ArrayList<List<Modifier>>();
        List<Modifier> chosen = null;
        if (addUpTo < 0) {
            min = addUpTo;
            max = -1;
        } else if (addUpTo > 0) {
            min = 1;
            max = addUpTo;
        } else {
            min = -4;
            max = 4;
            if (addUpTo != 0) {
                TannLog.error("hmm minmax " + addUpTo);
            }
        }
        int amtWildcard = 0;
        if (wildcard) {
            amtWildcard = Tann.randomRound((float)amt / 8.0f);
        }
        int META_ATTEMPTS = 5;
        int INNER_ATTEMPTS = 100;
        int pn = 0;
        for (int metaAttempt = 0; metaAttempt < 5; ++metaAttempt) {
            List<Modifier> totalBase = modifierPickContext.getBase(new ArrayList<Modifier>(), min, max, amt * 7, collisionBit);
            for (int i = 0; i < 100; ++i) {
                ArrayList chooseFrom = new ArrayList(totalBase);
                Collections.shuffle(chooseFrom);
                int numNormal = amt - amtWildcard;
                List<Modifier> potentialList = Tann.getSelectiveRandom(chooseFrom, numNormal, ModifierLib.getMissingno(), avoid, seen);
                if (amtWildcard > 0) {
                    potentialList.addAll(ModifierPickUtils.generateModifiers(-max, -min, amtWildcard, modifierPickContext, avoid, seen, collisionBit));
                }
                if (ModifierPickUtils.anyMissingno(potentialList)) continue;
                PermStats perm = PermStats.make(addUpTo, potentialList);
                if (perm == null) {
                    ++pn;
                    continue;
                }
                if (perm.isFine()) {
                    chosen = potentialList;
                    break;
                }
                modLists.add(potentialList);
            }
            if (chosen != null || modLists.size() > 10) break;
        }
        final HashMap<List, PermStats> cachedPermStats = new HashMap<List, PermStats>();
        for (List list : modLists) {
            cachedPermStats.put(list, PermStats.make(addUpTo, list));
        }
        if (chosen == null) {
            TannLog.error("Failed to find " + pn + ":" + modLists.size());
            if (modLists.isEmpty()) {
                return ModifierPickUtils.getFailsafeModifierOffer(amt, addUpTo, modifierPickContext);
            }
            Collections.sort(modLists, new Comparator<List<Modifier>>(){

                @Override
                public int compare(List<Modifier> offer1, List<Modifier> offer2) {
                    return PermStats.COMPARE((PermStats)cachedPermStats.get(offer1), (PermStats)cachedPermStats.get(offer2));
                }
            });
            chosen = (List<Modifier>)modLists.get(0);
            PermStats a = PermStats.make(addUpTo, chosen);
            TannLog.log("After sorting picked offer " + a);
        }
        Collections.sort(chosen, new Comparator<Modifier>(){

            @Override
            public int compare(Modifier o1, Modifier o2) {
                int o2v;
                int o1v = Math.abs(o1.getTier());
                if (o1v != (o2v = Math.abs(o2.getTier()))) {
                    return o2v - o1v;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        ModifierLib.getCache().decache(chosen);
        return chosen;
    }

    private static boolean anyMissingno(List<Modifier> lszt) {
        for (int i = 0; i < lszt.size(); ++i) {
            if (!lszt.get(i).isMissingno()) continue;
            return true;
        }
        return false;
    }

    public static List<Modifier> generateModifiers(int tier, int amt, ModifierPickContext context, DungeonContext dc) {
        return ModifierPickUtils.generateModifiers(tier, tier, amt, context, dc);
    }

    public static List<Modifier> generateModifiers(Integer min, Integer max, int amt, ModifierPickContext context, DungeonContext dc) {
        ArrayList<Modifier> currentPlusAvoid = new ArrayList<Modifier>(dc.getCurrentModifiers());
        currentPlusAvoid.addAll(dc.getAvoidModifiers());
        return ModifierPickUtils.generateModifiers(min, max, amt, context, currentPlusAvoid, dc.makeSeenModifiers(), dc.getBannedCollisionBits());
    }

    private static List<Modifier> generateModifiers(Integer min, Integer max, int amt, ModifierPickContext context, List<Modifier> current, List<Modifier> seen, long collisionBit) {
        if (min != null && max != null && min > max) {
            throw new RuntimeException("Invalid args: " + min + "/" + max);
        }
        List<Modifier> base = context.getBase(current, min, max, amt * 7, collisionBit);
        List<Modifier> result = Tann.getSelectiveRandom(base, amt, ModifierLib.getMissingno(), current, seen);
        ModifierPickUtils.replaceMissingnoWithGenerated(result, min, max, current);
        return result;
    }

    private static void replaceMissingnoWithGenerated(List<Modifier> result, Integer min, Integer max, List<Modifier> current) {
        int i;
        boolean anyMiss = false;
        for (int i2 = 0; i2 < result.size(); ++i2) {
            anyMiss |= result.get(i2).isMissingno();
        }
        if (!anyMiss) {
            return;
        }
        ArrayList<String> cNames = new ArrayList<String>();
        for (i = 0; i < current.size(); ++i) {
            cNames.add(current.get(i).getName());
        }
        for (i = 0; i < result.size(); ++i) {
            Modifier m;
            if (!result.get(i).isMissingno() || (m = ModifierPickUtils.makeReplacement(result, cNames, min, max)) == null) continue;
            result.set(i, m);
        }
    }

    private static Modifier makeReplacement(List<Modifier> result, List<String> current, Integer min, Integer max) {
        int attempts = 1000;
        for (int i = 0; i < attempts; ++i) {
            Modifier m;
            List<Modifier> lst = PipeMod.makeGenerated(1, min, max, Tann.chance(0.2f));
            if (lst.isEmpty() || result.contains(m = lst.get(0)) || current.contains(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static List<Modifier> getFailsafeModifierOffer(int amt, int addUpTo, ModifierPickContext modifierPickContext) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.add(ModifierLib.getMissingno());
        float delta = Math.abs((float)addUpTo * 0.3f);
        for (int i = 1; i < amt; ++i) {
            int tier = (int)((float)(addUpTo / 2) + Tann.random(-delta, delta));
            result.addAll(ModifierPickUtils.generateModifiers(tier, 1, modifierPickContext, DebugUtilsUseful.dummyContext()));
        }
        result.add(ModifierLib.getMissingno());
        return result;
    }
}

