/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier;

import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.util.Tann;
import java.util.List;

public class PermStats {
    final int validCombinations;
    final boolean usedAll;
    final boolean noMandatories;

    public PermStats(int validCombinations, boolean usedAll, boolean noMandatories) {
        this.validCombinations = validCombinations;
        this.usedAll = usedAll;
        this.noMandatories = noMandatories;
    }

    public static int COMPARE(PermStats offer1Stats, PermStats offer2Stats) {
        if (offer1Stats.usedAll != offer2Stats.usedAll) {
            if (offer1Stats.usedAll) {
                return -1;
            }
            return 1;
        }
        if (offer1Stats.noMandatories != offer2Stats.noMandatories) {
            if (offer1Stats.noMandatories) {
                return -1;
            }
            return 1;
        }
        return offer2Stats.validCombinations - offer1Stats.validCombinations;
    }

    public boolean isFine() {
        return this.usedAll && this.noMandatories && this.validCombinations >= 6;
    }

    public String toString() {
        return this.usedAll + ":" + this.noMandatories + ":" + this.validCombinations;
    }

    public static PermStats make(int target, List<Modifier> modifiers) {
        int mask;
        int validCombinations = 0;
        int usedModifiers = 0;
        int cannotDoWithout = mask = (1 << modifiers.size()) - 1;
        if (modifiers.size() > 12) {
            int total = 0;
            int totalNegative = 0;
            int totalPositive = 0;
            int biggestPositive = 0;
            int biggestNegative = 5000;
            for (Modifier modifier : modifiers) {
                int tier = modifier.getTier();
                if (tier > 0) {
                    totalPositive += tier;
                } else {
                    totalNegative += tier;
                }
                biggestNegative = Math.min(biggestNegative, tier);
                biggestPositive = Math.max(biggestPositive, tier);
                total += modifier.getTier();
            }
            if (Tann.further(total, target * 2) && biggestNegative + totalPositive >= target && biggestPositive + totalNegative <= target) {
                validCombinations = 20;
                usedModifiers = mask;
                cannotDoWithout = 0;
            }
        } else {
            for (int bitmap = 0; bitmap <= mask; ++bitmap) {
                int total = 0;
                for (int j = 0; j < modifiers.size(); ++j) {
                    if ((bitmap & 1 << j) == 0) continue;
                    total += modifiers.get(j).getTier();
                }
                if (total != target) continue;
                ++validCombinations;
                usedModifiers |= bitmap;
                cannotDoWithout &= bitmap;
            }
        }
        return new PermStats(validCombinations, usedModifiers == mask, cannotDoWithout == 0);
    }
}

