/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.meta;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MissingnoPhase;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SeqPhase
extends Phase {
    String message;
    final List<SPP> spps;
    Actor a;

    public SeqPhase(String message, List<SPP> spps) {
        this.message = message;
        this.spps = spps;
    }

    public SeqPhase(String data) {
        this.spps = new ArrayList<SPP>();
        String[] parts = data.split("@1");
        if (parts.length < 2) {
            throw new RuntimeException("Invalid seqphase: " + data);
        }
        this.message = parts[0];
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            String[] p2 = part.split("@2");
            ArrayList<String> p2cpy = new ArrayList<String>(Arrays.asList(p2));
            p2cpy.remove(0);
            this.spps.add(new SPP(p2[0], p2cpy));
        }
    }

    @Override
    public String serialise() {
        return "s" + this.message + "@1" + Tann.commaList(this.spps, "@1");
    }

    @Override
    public void activate() {
        Sounds.playSound(Sounds.pip);
        final DungeonScreen ds = DungeonScreen.get();
        if (ds == null) {
            TannLog.error("Activating metaphase when not in dungeonscreen");
            return;
        }
        Pixl p = new Pixl(8, 8).border(Colours.grey);
        p.text(this.message).row();
        for (final SPP ph : this.spps) {
            Actor butt = ph.getLevelEndButton();
            p.actor(butt, (float)Main.width * 0.5f);
            butt.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    SeqPhase.this.pickPhase(ph);
                    return true;
                }

                @Override
                public boolean info(int button, float x, float y) {
                    ds.showDialog(ph.getClass().getSimpleName());
                    return true;
                }
            });
        }
        this.a = p.pix();
        ds.addActor(this.a);
        Tann.center(this.a);
        Tann.slideIn(this.a, Tann.TannPosition.Top, (int)((float)(Main.height / 2) - this.a.getHeight() / 2.0f));
    }

    private void pickPhase(SPP ph) {
        Sounds.playSound(Sounds.pip);
        List<String> phases = ph.phases;
        for (int i = phases.size() - 1; i >= 0; --i) {
            String phase = phases.get(i);
            Phase p = Phase.deserialise(phase);
            PhaseManager.get().forceNext(p);
        }
        PhaseManager.get().popPhase(this.getClass());
        DungeonScreen.get().save();
    }

    private Phase roundTrip(Phase a) {
        return Phase.deserialise(a.serialise());
    }

    @Override
    protected StandardButton getLevelEndButtonInternal() {
        return new StandardButton(TextWriter.getTag(this.getLevelEndColour()) + "chain", this.getLevelEndColour(), 53, 20);
    }

    @Override
    public void deactivate() {
        Tann.slideAway(this.a, Tann.TannPosition.Bot, true);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public Color getLevelEndColour() {
        return Colours.purple;
    }

    @Override
    public boolean isInvalid() {
        for (SPP spp : this.spps) {
            for (String phase : spp.phases) {
                Phase p = Phase.deserialise(phase);
                if (!(p instanceof MissingnoPhase) && !p.isInvalid()) continue;
                return true;
            }
        }
        return false;
    }

    static class SPP {
        final String title;
        final List<String> phases;

        SPP(String title, List<String> phases) {
            this.title = title;
            this.phases = phases;
        }

        public Actor getLevelEndButton() {
            return new StandardButton(this.title);
        }

        public String toString() {
            return this.title + "@2" + Tann.commaList(this.phases, "@2");
        }
    }
}

