/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress.chievo.unlock;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.leaderboard.Leaderboard;
import com.tann.dice.gameplay.leaderboard.StreakLeaderboard;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.meta.folder.FolderMode;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.progress.chievo.AchLib;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.save.settings.option.BOption;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.LedgerPage;
import com.tann.dice.util.Pixl;
import java.util.ArrayList;
import java.util.List;

public class UnUtil {
    public static boolean isLocked(Unlockable u) {
        if (Main.demo && u == Mode.CLASSIC) {
            return true;
        }
        if (u instanceof HeroType && UnUtil.isLocked(((HeroType)u).heroCol)) {
            return true;
        }
        if (u instanceof FolderMode && ((FolderMode)u).isLocked()) {
            return true;
        }
        if (u instanceof StreakLeaderboard) {
            StreakLeaderboard sl = (StreakLeaderboard)u;
            Difficulty d = sl.difficulty;
            if (d != null && UnUtil.isLocked(d)) {
                return true;
            }
        }
        return Main.unlockManager().isLocked(u);
    }

    public static boolean wasLocked(Unlockable u) {
        return AchLib.hasAchievement(u) && !Main.unlockManager().isLocked(u);
    }

    public static String nameFor(Unlockable u) {
        return UnUtil.nameFor(u.getClass());
    }

    public static String nameFor(Class<? extends Unlockable> aClass) {
        if (aClass.isAnonymousClass()) {
            aClass = aClass.getSuperclass();
        }
        if (Mode.class.isAssignableFrom(aClass)) {
            return "mode";
        }
        if (Leaderboard.class.isAssignableFrom(aClass)) {
            return "leaderboard";
        }
        if (aClass == HeroType.class) {
            return "hero";
        }
        if (aClass == LedgerPage.LedgerPageType.class) {
            return "ledger page";
        }
        if (aClass == MonsterType.class) {
            return "monster";
        }
        if (aClass == BOption.class) {
            return "option";
        }
        return aClass.getSimpleName().toLowerCase();
    }

    public static List<Unlockable> makeAll(Boolean everLocked) {
        ArrayList<Unlockable> result = new ArrayList<Unlockable>();
        result.addAll(ItemLib.getMasterCopy());
        result.addAll(ModifierLib.getAll());
        result.addAll(EntTypeUtils.getAll());
        result.addAll(Mode.getAllModes());
        result.addAll(OptionLib.getAll());
        if (everLocked != null) {
            for (int i = result.size() - 1; i >= 0; --i) {
                if (AchLib.hasAchievement((Unlockable)result.get(i)) == everLocked) continue;
                result.remove(i);
            }
        }
        return result;
    }

    public static Actor makeDefaultUnlock(String colourTaggedString, boolean big) {
        return new Pixl(2).text(colourTaggedString).pix();
    }
}

