/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.speech.statSnap;

import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.command.DieCommand;
import com.tann.dice.gameplay.fightLog.event.entState.ChatStateEvent;
import com.tann.dice.gameplay.progress.StatSnapshot;
import com.tann.dice.gameplay.trigger.global.speech.GlobalSpeech;
import com.tann.dice.gameplay.trigger.global.speech.statSnap.GlobalSpeechStatSnapshot;
import com.tann.dice.util.Tann;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class GlobalSpeechEnvy
extends GlobalSpeechStatSnapshot {
    final ChatStateEvent cse;

    protected GlobalSpeechEnvy(ChatStateEvent cse) {
        this.cse = cse;
    }

    public static Collection<? extends GlobalSpeech> makeEnvies() {
        return Arrays.asList(new GlobalSpeechEnvy(new ChatStateEvent(0.1f, "Impressive!", "Nice healing", "I could have done that...", "[i]takes notes[i]", "...")){

            @Override
            protected boolean enviousCommand(Hero h, StatSnapshot ss) {
                if (h.getHeroCol() == HeroCol.red) {
                    return false;
                }
                float THRESHOLD = (float)Math.pow(h.getLevel(), 1.7f) + 3.0f;
                int totalHpPre = 0;
                int totalHpPost = 0;
                for (EntState es : ss.beforeCommand.getStates(true, false)) {
                    totalHpPre += es.getHp();
                }
                for (EntState es : ss.afterCommand.getStates(true, false)) {
                    totalHpPost += es.getHp();
                }
                return !((float)totalHpPost < (float)totalHpPre + THRESHOLD);
            }

            @Override
            protected EntState speechHero(List<EntState> heroes) {
                return 1.getHero(heroes, HeroCol.red);
            }
        }, new GlobalSpeechEnvy(new ChatStateEvent(0.1f, "Impressive!", "How did you learn that?", "I could have done that...", "[i]takes notes[i]")){

            @Override
            protected boolean enviousCommand(Hero h, StatSnapshot ss) {
                if (HeroTypeUtils.isSpelly(h.getHeroCol())) {
                    return false;
                }
                float THRESHOLD = h.getLevel() + 2;
                return !((float)ss.afterCommand.getTotalMana() < (float)ss.beforeCommand.getTotalMana() + THRESHOLD);
            }

            @Override
            protected EntState speechHero(List<EntState> heroes) {
                return 2.getHero(heroes, Tann.pick(HeroCol.blue, HeroCol.red));
            }
        });
    }

    protected abstract boolean enviousCommand(Hero var1, StatSnapshot var2);

    protected abstract EntState speechHero(List<EntState> var1);

    @Override
    protected void snapshot(StatSnapshot ss) {
        if (!this.cse.chance()) {
            return;
        }
        if (!(ss.origin instanceof DieCommand)) {
            return;
        }
        DieCommand dc = (DieCommand)ss.origin;
        Ent en = dc.getSource();
        if (en == null || !en.isPlayer()) {
            return;
        }
        if (!this.enviousCommand((Hero)en, ss)) {
            return;
        }
        EntState target = this.speechHero(ss.afterCommand.getStates(true, false));
        if (target == null) {
            return;
        }
        target.addEvent(this.cse);
    }

    protected static EntState getHero(List<EntState> heroes, HeroCol col) {
        for (EntState e : heroes) {
            if (!e.isPlayer() || ((Hero)e.getEnt()).getHeroCol() != col) continue;
            return e;
        }
        return null;
    }
}

