/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.eff;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.SimpleTargetable;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.personal.eff.PersonalEffContainer;
import com.tann.dice.util.Pixl;
import java.util.ArrayList;
import java.util.List;

public class StartOfCombat
extends PersonalEffContainer {
    public final Eff eff;

    public StartOfCombat(Eff eff) {
        super(eff);
        this.eff = eff;
    }

    @Override
    public void startOfCombat(Snapshot snapshot, EntState entState) {
        snapshot.target(null, new SimpleTargetable(entState.getEnt(), this.eff), false);
    }

    @Override
    public String describeForSelfBuff() {
        return "Start of turn 1: " + this.eff.describe();
    }

    @Override
    public List<Keyword> getReferencedKeywords() {
        ArrayList<Keyword> referenced = new ArrayList<Keyword>(this.eff.getKeywords());
        referenced.remove((Object)Keyword.boost);
        return referenced;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        String col;
        String string = col = this.eff.isFriendly() ? "[green]" : "[red]";
        if (this.eff.getTargetingType() == TargetingType.Untargeted) {
            col = "[green]";
        }
        col = "[text]";
        Actor effImage = this.eff.getBasicImage();
        return new Pixl().text(col + "t1: ").actor(effImage).pix();
    }
}

