/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.specialPips;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.SimpleTargetable;
import com.tann.dice.gameplay.effect.targetable.Targetable;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.event.entState.StateEvent;
import com.tann.dice.gameplay.fightLog.event.snapshot.SnapshotEvent;
import com.tann.dice.gameplay.trigger.personal.Stunned;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.immunity.DamageImmunity;
import com.tann.dice.gameplay.trigger.personal.position.BackRow;
import com.tann.dice.gameplay.trigger.personal.specialPips.SpecialHp;
import com.tann.dice.gameplay.trigger.personal.specialPips.pipLoc.PipLoc;
import com.tann.dice.statics.Images;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TriggerHP
extends SpecialHp {
    final Eff eff;
    final TextureRegion hpImage;
    final List<StateEvent> events;
    final SnapshotEvent snapshotEvent;
    final Color col;

    public TriggerHP(Eff eff, Color color, PipLoc loc) {
        this(eff, new ArrayList<StateEvent>(), color, loc);
    }

    public TriggerHP(Eff eff, TextureRegion pipImage, Color color, PipLoc loc) {
        this(eff, new ArrayList<StateEvent>(), null, pipImage, color, loc);
    }

    public TriggerHP(Eff eff, StateEvent event, Color col, PipLoc loc) {
        this(eff, Arrays.asList(event), col, loc);
    }

    public TriggerHP(Eff eff, List<StateEvent> events, Color color, PipLoc loc) {
        this(eff, events, null, color, loc);
    }

    public TriggerHP(Eff eff, List<StateEvent> events, SnapshotEvent snapshotEvent, Color color, PipLoc loc) {
        this(eff, events, snapshotEvent, Images.hp_hole, color, loc);
    }

    public TriggerHP(Eff eff, List<StateEvent> events, SnapshotEvent snapshotEvent, TextureRegion hpImage, Color color, PipLoc loc) {
        super(loc);
        this.eff = eff;
        this.events = events;
        this.snapshotEvent = snapshotEvent;
        this.col = color;
        this.hpImage = hpImage;
    }

    @Override
    protected String describe() {
        return this.eff.describe().toLowerCase().replaceAll("\\[n\\]", " ");
    }

    @Override
    public boolean showInEntPanelInternal() {
        return false;
    }

    @Override
    public boolean showInDiePanel() {
        return true;
    }

    protected int willTrigger(int oldMinHp, int newHp, int maxHp) {
        int result = 0;
        for (int threshold : this.getPips(maxHp)) {
            if (oldMinHp <= threshold || newHp > threshold) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void damageTaken(EntState source, EntState self, Snapshot snapshot, int damage, int damageTakenThisTurn, Eff sourceEff, Targetable targetable, int minTriggerPipHp) {
        int oldHp = minTriggerPipHp;
        int newHp = self.getHp();
        boolean triggered = false;
        for (int i = 0; i < this.willTrigger(oldHp, newHp, self.getMaxHp()); ++i) {
            triggered = true;
            if (this.eff.getTargetingType() == TargetingType.Self) {
                self.hit(this.eff, self.getEnt());
                continue;
            }
            snapshot.target(null, new SimpleTargetable(self.getEnt(), this.eff), false);
        }
        if (triggered) {
            for (StateEvent event : this.events) {
                if (!event.chance()) continue;
                self.addEvent(event);
            }
            if (this.snapshotEvent != null) {
                snapshot.addEvent(this.snapshotEvent);
            }
        }
        super.damageTaken(source, self, snapshot, damage, damageTakenThisTurn, sourceEff, targetable, minTriggerPipHp);
    }

    @Override
    public TP<TextureRegion, Color> getPipTannple(boolean big) {
        return new TP<TextureRegion, Color>(big ? this.hpImage : Images.hp_small, this.col);
    }

    @Override
    public float affectStrengthCalc(float total, float avgRawValue, EntType type) {
        int[] pips = this.getPips(type.hp);
        int numPips = pips.length;
        float pipsPerHp = (float)type.hp / (float)numPips;
        switch (this.eff.getType()) {
            case Mana: {
                return total - 0.5f;
            }
            case Kill: {
                return total + (float)(2 * pips.length);
            }
            case Damage: {
                switch (this.eff.getTargetingType()) {
                    case Group: {
                        return total + (float)this.eff.getValue() * 1.0f * (float)pips.length;
                    }
                    case Top: 
                    case Bot: 
                    case Mid: {
                        return total + (float)this.eff.getValue() * 0.2f * (float)pips.length;
                    }
                }
                throw new RuntimeException("invalid triggerpip damage");
            }
            case Shield: 
            case Heal: {
                return total;
            }
            case Buff: {
                if (this.eff.getBuff().trigger instanceof AffectSides) {
                    return total * ((avgRawValue + 0.25f * (float)pips.length) / avgRawValue);
                }
                if (this.eff.getBuff().trigger instanceof BackRow) {
                    return total;
                }
                if (this.eff.getBuff().trigger instanceof DamageImmunity) {
                    return total;
                }
                if (!(this.eff.getBuff().trigger instanceof Stunned)) break;
                float lowerBound = 0.06f;
                float mult = (float)Math.pow(pipsPerHp, -0.49);
                float val = total * (lowerBound + (1.0f - lowerBound) * (1.0f - mult));
                if (type.calcBackRow(0)) {
                    val = Interpolation.linear.apply(val, total, 0.7f);
                }
                return val;
            }
        }
        if (this.eff.hasKeyword(Keyword.cleanse)) {
            return total;
        }
        return super.affectStrengthCalc(total, avgRawValue, type);
    }

    @Override
    public float affectTotalHpCalc(float hp, EntType entType) {
        int[] pips = this.getPips(entType);
        switch (this.eff.getType()) {
            case Mana: {
                return hp + -0.75f * (float)pips.length;
            }
            case Damage: {
                if (hp > 10.0f) {
                    return hp + (float)(2 * pips.length);
                }
                float extraMult = this.eff.getTargetingType() == TargetingType.Group ? 3.0f : 1.0f;
                return hp + (float)this.eff.getValue() * 0.1f * (float)pips.length * extraMult;
            }
            case Shield: {
                return hp + (float)(this.eff.getValue() * pips.length) * 0.7f;
            }
            case Heal: {
                return hp + (float)pips.length * Math.min(hp / 2.0f, (float)this.eff.getValue()) * 0.9f;
            }
            case Buff: {
                if (this.eff.getBuff().trigger instanceof AffectSides) {
                    return hp;
                }
                if (this.eff.getBuff().trigger instanceof BackRow) {
                    return hp + 1.1f;
                }
                if (this.eff.getBuff().trigger instanceof DamageImmunity) {
                    return hp + 1.2f * (float)pips.length;
                }
                if (!(this.eff.getBuff().trigger instanceof Stunned)) break;
                return hp;
            }
            case Kill: {
                return (float)((double)hp * Math.pow(1.15f, pips.length));
            }
        }
        if (this.eff.hasKeyword(Keyword.cleanse)) {
            return hp * 1.05f;
        }
        return super.affectTotalHpCalc(hp, entType);
    }

    public boolean lateTrigger() {
        return this.eff.getType() == EffType.Summon;
    }

    @Override
    public float getPriority() {
        return this.lateTrigger() ? -4.0f : -5.0f;
    }

    @Override
    public long getCollisionBits(Boolean player) {
        if (this.eff != null) {
            return this.eff.getCollisionBits(player);
        }
        return 0L;
    }
}

