/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.platform.control;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.platform.control.Control;
import com.tann.dice.screens.dungeon.panels.book.page.helpPage.HelpSnippet;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialQuest;
import java.util.Arrays;
import java.util.List;

public abstract class SmartphoneControl
extends Control {
    @Override
    public void affectAdvertLines(List<String> lines) {
    }

    @Override
    public String getSelectTapString() {
        return "Tap";
    }

    @Override
    public String getInfoTapString() {
        return "Tap and hold";
    }

    @Override
    public boolean allowLongPress() {
        return true;
    }

    @Override
    public int getConfirmButtonThumbpadRadius() {
        return Main.isPortrait() ? -1 : 18;
    }

    @Override
    public List<TutorialQuest> getExtraTargetingPhaseQuests() {
        return Arrays.asList(SmartphoneControl.makeRotate(true), SmartphoneControl.makeRotate(false));
    }

    private static TutorialQuest makeRotate(final boolean portrait) {
        String n = portrait ? "portrait" : "landscape";
        return new TutorialQuest(0, "Try rotating your device to " + n + "[n][grey](may require device auto-rotate)"){

            @Override
            public boolean isValid(FightLog fightLog) {
                return Main.isPortrait() != portrait && fightLog.getContext().getCurrentLevelNumber() > 2;
            }

            @Override
            public void loadIn() {
                if (Main.isPortrait() == portrait) {
                    this.markCompleted();
                }
            }
        };
    }

    @Override
    public boolean saveContentEncryption() {
        return false;
    }

    @Override
    public String getMainFileString() {
        return "slice-and-dice-3";
    }

    @Override
    public List<Actor> getTipsSnippets(int contentWidth) {
        return Arrays.asList(new HelpSnippet("It's maybe possible to play with one hand in portrait orientation, use the ui option 'longtap end' to help with corner buttons. And remember you can also tap heroes to lock/unlock their dice."));
    }
}

