/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.book.page.cogPage.menuPanel.EscMenuUtils;
import com.tann.dice.screens.dungeon.panels.hourglass.HourglassUtils;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;

public class DungeonUtils {
    public static Group makeButtonsGroup(DungeonContext dungeonContext, FightLog fightLog, DungeonScreen ds) {
        if (Main.isPortrait()) {
            return DungeonUtils.makeButtonsGroupPortrait(dungeonContext, fightLog, ds);
        }
        return DungeonUtils.makeButtonsGroupLandscape(dungeonContext, fightLog, ds);
    }

    private static Group makeButtonsGroupLandscape(DungeonContext dungeonContext, FightLog fightLog, DungeonScreen ds) {
        int gap = 5;
        Pixl optionsPixl = new Pixl(gap);
        optionsPixl.actor(DungeonUtils.makeCog()).actor(dungeonContext.makeHashButton());
        Actor hourglass = HourglassUtils.makeHourglassButton(fightLog.getSnapshot());
        if (hourglass != null) {
            optionsPixl.actor(hourglass);
        }
        if (DungeonUtils.shouldShowTargetButton(dungeonContext)) {
            optionsPixl.actor(DungeonUtils.makeTargetButton(ds));
        }
        return optionsPixl.pix();
    }

    public static int getPortraitPanelY(Group optionsButtonsGroup) {
        return (int)((float)Main.height - optionsButtonsGroup.getHeight());
    }

    private static Group makeButtonsGroupPortrait(DungeonContext dungeonContext, FightLog fightLog, DungeonScreen ds) {
        int gap = 5;
        Pixl optionsPixl = new Pixl(gap, 4);
        optionsPixl.actor(DungeonUtils.makeCog()).row().actor(dungeonContext.makeHashButton());
        Actor hourglass = HourglassUtils.makeHourglassButton(fightLog.getSnapshot());
        if (hourglass != null) {
            optionsPixl.row().actor(hourglass);
        }
        if (DungeonUtils.shouldShowTargetButton(dungeonContext)) {
            optionsPixl.row().actor(DungeonUtils.makeTargetButton(ds));
        }
        Group result = optionsPixl.pix();
        return result;
    }

    public static boolean shouldShowTargetButton(DungeonContext dc) {
        return dc.getParty().anyDuplicateCols() || OptionLib.ALWAYS_SHOW_TARG_BUTTON.c();
    }

    public static Actor makeBasicButton(TextureRegion tr) {
        return DungeonUtils.makeBasicButton(tr, false);
    }

    public static Actor makeBasicButton(TextureRegion tr, boolean big) {
        ImageActor ia = new ImageActor(big ? Images.minibuttBaseBig : Images.minibuttBase);
        Group g = Tann.makeGroup(ia);
        ImageActor middle = new ImageActor(tr);
        g.addActor(middle);
        Tann.center(middle);
        return g;
    }

    public static TextureRegion getBaseImage() {
        return Images.minibuttBase;
    }

    public static Actor makeTargetButton(final DungeonScreen ds) {
        final TextureRegion base = DungeonUtils.getBaseImage();
        Actor target = new Actor(){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                batch.setColor(Colours.z_white);
                batch.draw(base, this.getX(), this.getY());
                if (PhaseManager.get().getPhase().showTargetButton()) {
                    batch.setColor(Colours.red);
                } else {
                    batch.setColor(Colours.withAlpha(Colours.grey, 0.5f));
                }
                TextureRegion tr = Images.targetIcon;
                batch.draw(tr, (float)((int)(this.getX() + this.getWidth() / 2.0f - (float)(tr.getRegionWidth() / 2))), (float)((int)(this.getY() + this.getHeight() / 2.0f - (float)(tr.getRegionHeight() / 2))));
                super.draw(batch, parentAlpha);
            }
        };
        target.setSize(base.getRegionWidth(), base.getRegionHeight());
        target.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                for (Ent entity : ds.hero.getEntities()) {
                    entity.getEntPanel().setArrowIntensity(1.0f, -1.0f);
                }
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                for (Ent entity : ds.hero.getEntities()) {
                    entity.getEntPanel().setArrowIntensity(0.0f, -1.0f);
                }
            }
        });
        return target;
    }

    public static Actor makeCog() {
        Actor cog = DungeonUtils.makeBasicButton(Images.cog);
        cog.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                DungeonUtils.showCogMenu();
                Sounds.playSound(Sounds.pip);
                return true;
            }
        });
        return cog;
    }

    public static void showCogMenu() {
        String t = "cog";
        Screen s = Main.getCurrentScreen();
        Actor a = s.getTopPushedActor();
        if (a != null && "cog".equals(a.getName())) {
            Main.getCurrentScreen().pop(a);
        }
        a = EscMenuUtils.makeFullEscMenu();
        s.push(a, true, true, false, 0.5f);
        a.setName("cog");
        Tann.center(a);
    }

    public static class CogTag
    extends Actor {
    }
}

