/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.Explanel;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.effect.Buff;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.Targetable;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellUtils;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.TargetingManager;
import com.tann.dice.screens.dungeon.panels.DieSidePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.InfoPanel;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.util.AlternativePop;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Extendobar;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.PostPop;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.Button;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;

public class Explanel
extends InfoPanel
implements PostPop,
AlternativePop {
    private Object showing;
    Color border = Colours.light;
    NinePatch ninePatch;
    List<Actor> belowActors = new ArrayList<Actor>();
    List<Actor> extras = new ArrayList<Actor>();

    public Explanel() {
        this.setTransform(false);
    }

    public Explanel(EntSide side, Ent source) {
        this();
        String dsc;
        TextWriter tx;
        EntSideState ess;
        int sideTextWidth = 85;
        this.showing = side;
        this.border = source == null ? Colours.purple : source.getColour();
        int gap = 3;
        Eff e = side.getBaseEffect();
        if (source != null && (ess = side.findState(FightLog.Temporality.Visual, source)) != null) {
            e = ess.getCalculatedEffect();
        }
        if ((tx = new TextWriter(dsc = "[text]" + side.toString(source), 85)).getWidth() > 60.0f && tx.getHeight() < 8.0f) {
            tx = new TextWriter(dsc, 51);
        }
        Tann.become(this, new Pixl(gap, gap).actor(new DieSidePanel(side, source)).actor(tx).pix());
        this.addKeywords(e.getKeywordsForDisplay(true), e);
    }

    public Explanel(Ability ability, boolean showKeywords) {
        this();
        this.showing = ability;
        this.ninePatch = Button.ninePatchAbility;
        this.border = ability.getCol();
        int TOP_GAP_L = 6;
        int TOP_GAP_R = 7;
        Pixl p = new Pixl(3, 2);
        if (ability.useImage()) {
            p.image(ability.getImage()).gap(6);
        }
        p.text(TextWriter.getTag(ability.getIdCol()) + ability.getTitle()).gap(7);
        p.actor(SpellUtils.makeAbilityCostActor(ability));
        p.row(2).actor(new Extendobar(this.border)).row(1);
        p.actor(new TextWriter("[text]" + ability.describe(), 85)).row(0);
        Tann.become(this, p.pix());
        if (showKeywords) {
            this.addKeywords(ability.getDerivedEffects());
        }
    }

    public Explanel(Trait trait, Ent ent, float width) {
        this(trait.personal, ent, false, width);
    }

    public Explanel(Personal trigger, Ent ent, Boolean incoming, float width) {
        this();
        this.showing = trigger;
        int borderSize = 2;
        String text = "";
        TextureRegion triggerImage = trigger.getImage();
        if (trigger.hasImage() && trigger.showInDiePanel() && trigger.showImageInDiePanelTitle()) {
            text = TextWriter.getTag(trigger.getImageCol()) + "[image][cu][h]: ";
        }
        text = text + "[text]" + trigger.describeForTriggerPanel();
        text = text + this.getIncomingText(incoming, trigger);
        if (!trigger.hasImage()) {
            triggerImage = trigger.getSpecialImage();
        }
        TextWriter tw = new TextWriter(text, (int)width - borderSize * 2, ent.getColour(), borderSize, triggerImage);
        tw.setWidth(width);
        this.addActor(tw);
        this.setSize(tw.getWidth(), tw.getHeight());
        if (Tann.notNullOrEmpty(trigger.getReferencedKeywords())) {
            this.addKeywords(trigger.getReferencedKeywords(), null);
        }
    }

    private String getIncomingText(Boolean incoming, Personal pt) {
        Buff b = pt.buff;
        if (incoming == null) {
            if (b == null) {
                return "Hm!?? incoming null and buff null";
            }
            if (!b.isInfinite()) {
                return " [yellow](incoming)[cu]";
            }
            return " [yellow](partly-incoming)[cu]";
        }
        if (incoming.booleanValue()) {
            return " [yellow](incoming)[cu]";
        }
        return "";
    }

    private void addKeywords(Eff e) {
        this.addKeywords(e.getKeywordsForDisplay(true), e);
    }

    private void addKeywords(List<Keyword> keywords, Eff source) {
        int y = -2;
        for (int i = 0; i < keywords.size(); ++i) {
            Keyword k = keywords.get(i);
            Actor a = KUtils.makeActor(k, source);
            this.addActor(a);
            y = (int)((float)y - (a.getHeight() - 1.0f));
            a.setPosition((int)(this.getWidth() / 2.0f - a.getWidth() / 2.0f), y);
            this.extras.add(a);
            this.belowActors.add(a);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.border != null) {
            if (this.ninePatch != null) {
                Draw.fillActor(batch, (Actor)this, Colours.dark, 1);
                batch.setColor(this.border);
                this.ninePatch.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            } else {
                Draw.fillActor(batch, this, Colours.dark, this.border, 1);
            }
        }
        super.draw(batch, parentAlpha);
    }

    @Override
    public void postPop() {
        Ent source;
        if (DungeonScreen.get() == null) {
            return;
        }
        TargetingManager targetingManager = DungeonScreen.get().targetingManager;
        Targetable targetable = targetingManager.getSelectedTargetable();
        if (targetable != null && (source = targetable.getSource()) != null) {
            source.getEntPanel().slideBack();
        }
        targetingManager.deselectTargetable();
        Actor top = Main.getCurrentScreen().getTopPushedActor();
        if (top == null || !(top instanceof DiePanel)) {
            targetingManager.hideTargetingArrows();
        }
    }

    public boolean isShowing(Object o) {
        return o == this.showing;
    }

    public void reposition() {
        Actor a = Main.getCurrentScreen().getTopPushedActor();
        if (!(a instanceof ExplanelReposition)) {
            a = Main.getCurrentScreen();
        }
        if (a instanceof ExplanelReposition) {
            ((ExplanelReposition)((Object)a)).repositionExplanel(this);
        }
    }

    public void addDialog(String noTargetsString, boolean above) {
        this.addDialog(new TextWriter(noTargetsString, Integer.MAX_VALUE, Colours.purple, 2), above);
    }

    public void addDialog(Actor actor, boolean above) {
        int yPos = 0;
        yPos = !above ? (int)(-actor.getHeight()) - 1 : (int)this.getHeight() + 1;
        for (Actor a : this.getChildren()) {
            if (above) {
                yPos = (int)Math.max(a.getY() + a.getHeight(), (float)yPos);
                continue;
            }
            yPos = (int)Math.min(a.getY() - actor.getHeight(), (float)yPos);
        }
        actor.setPosition((int)(this.getWidth() / 2.0f - actor.getWidth() / 2.0f), yPos);
        this.extras.add(actor);
        this.addActor(actor);
    }

    public int getFullHeight() {
        return (int)(this.getHeight() + (float)this.getExtraBelowExtent());
    }

    public int getExtraBelowExtent() {
        int botY = 0;
        for (Actor a : this.getChildren()) {
            botY = (int)Math.min((float)botY, a.getY());
        }
        return -botY;
    }

    public float getMaxWidth() {
        float width = this.getWidth();
        for (Actor a : this.getChildren()) {
            width = Math.max(a.getWidth(), width);
        }
        return width;
    }

    public void setBorder(Color border) {
        this.border = border;
    }

    public void addPassives(Ent ent) {
        int numTraits = 0;
        Pixl p = new Pixl(0);
        for (Personal t : ent.getState(FightLog.Temporality.Visual).getActiveTriggers()) {
            if (!t.showInDiePanel()) continue;
            ++numTraits;
            if (t.getTrait() != null) {
                p.actor(new Explanel(t.getTrait(), ent, Math.min(this.getWidth(), 100.0f)));
            } else {
                p.actor(new Explanel(t, ent, false, Math.min(this.getWidth(), 100.0f)));
            }
            p.row(-1);
        }
        if (numTraits > 0) {
            EntPanel ep = ent.getEntPanel();
            Vector2 explanelPos = Tann.getAbsoluteCoordinates(this).cpy();
            Vector2 panelPos = Tann.getAbsoluteCoordinates(ep).cpy();
            Vector2 relative = panelPos.sub(explanelPos);
            Group allTraits = p.pix();
            int xPos = (int)(relative.x + ep.getWidth() / 2.0f - allTraits.getWidth() / 2.0f);
            xPos = (int)Math.min((float)xPos, (float)Main.width - allTraits.getWidth() - explanelPos.x);
            int yPos = (int)(relative.y - allTraits.getHeight() + 1.0f);
            allTraits.setPosition(xPos, yPos);
            this.addActor(allTraits);
        }
    }

    public Group treatExtrasAsMain() {
        Pixl p = new Pixl(1);
        for (Actor a : this.extras) {
            a.remove();
            p.actor(a).row();
        }
        return p.pix();
    }

    @Override
    public boolean alternativePop() {
        for (Actor a : this.extras) {
            a.remove();
        }
        return false;
    }
}

