/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page.stuffPage;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.leaderboard.Leaderboard;
import com.tann.dice.gameplay.leaderboard.LeaderboardBlob;
import com.tann.dice.gameplay.leaderboard.LeaderboardDisplay;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.progress.RunHistoryStore;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.save.RunHistory;
import com.tann.dice.screens.dungeon.panels.book.TopTab;
import com.tann.dice.screens.dungeon.panels.book.page.BookPage;
import com.tann.dice.screens.dungeon.panels.book.page.cogPage.menuPanel.CreditsPanel;
import com.tann.dice.screens.dungeon.panels.book.page.cogPage.menuPanel.OptionsMenu;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.PatchBlob;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.Incantations;
import com.tann.dice.screens.graph.GraphUpdate;
import com.tann.dice.screens.graph.GraphUtils;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.statics.sound.music.JukeboxUtils;
import com.tann.dice.util.Colours;
import com.tann.dice.util.DebugUtilsUseful;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.VersionUtils;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StuffPage
extends BookPage {
    static final int CONTENT_GAP = 4;

    public StuffPage(Map<String, Stat> allMergedStats, int width, int height) {
        super("[grey]stuff", allMergedStats, width, height);
    }

    @Override
    public Color getColour() {
        return Colours.grey;
    }

    @Override
    protected List<TopTab> getAllListItems() {
        ArrayList<TopTab> result = new ArrayList<TopTab>();
        for (StuffSection sp : StuffSection.values()) {
            result.add(new TopTab(sp, sp.getColourTaggedString(), StuffPage.getSideWidth()));
        }
        return result;
    }

    @Override
    protected Actor getContentActorFromSidebar(Object type, int contentWidth) {
        switch ((StuffSection)type) {
            case Options: {
                return new OptionsMenu(contentWidth);
            }
            case Credits: {
                return CreditsPanel.make(contentWidth);
            }
            case Patch: {
                return StuffPage.makePatchGroup(contentWidth);
            }
            case Graph: {
                Actor a = GraphUtils.makeWidth(contentWidth, new GraphUpdate(){

                    @Override
                    public void newGraph(Actor newGraphs) {
                        StuffPage.this.showThing(newGraphs, true);
                    }
                });
                a.setName("bot");
                return a;
            }
            case Jukebox: {
                return JukeboxUtils.makeJukebox(contentWidth);
            }
            case Online: {
                return this.makeLeaderboard(null, contentWidth);
            }
            case Numbers: {
                return this.makeNumbersPage(contentWidth);
            }
        }
        return new TextWriter("//TODO");
    }

    private Actor makeGalleryPage(int type, final int contentWidth) {
        Pixl p = new Pixl();
        for (int i = 0; i < 3; ++i) {
            String typeName = "??";
            switch (i) {
                case 0: {
                    typeName = "2d";
                    break;
                }
                case 1: {
                    typeName = "3d";
                    break;
                }
                case 2: {
                    typeName = "2d-big";
                }
            }
            StandardButton sb = new StandardButton(typeName).makeTiny();
            final int finalI = i;
            sb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    StuffPage.this.showThing(StuffPage.this.makeGalleryPage(finalI, contentWidth));
                }
            });
            p.actor(sb);
            if (i >= 2) continue;
            p.gap(2);
        }
        p.row(3).text("[text]Good art by a3um, bad art by tann");
        p.row(3).actor(DebugUtilsUseful.showImages(type, contentWidth));
        return p.pix();
    }

    public static Group makePatchGroup(int contentWidth) {
        int MAX_WIDTH = contentWidth - 4;
        Pixl p = new Pixl(4).forceWidth(MAX_WIDTH);
        p.text("Current version: [yellow]" + VersionUtils.versionName).row();
        for (PatchBlob pb : PatchBlob.getRawData()) {
            p.actor(pb.makeActor(MAX_WIDTH)).row();
        }
        p.actor(new StandardButton("t", Colours.grey).setRunnable(new Runnable(){

            @Override
            public void run() {
                Main.self().control.textInput(new Input.TextInputListener(){

                    @Override
                    public void input(String text) {
                        Incantations.input(text);
                    }

                    @Override
                    public void canceled() {
                    }
                });
            }
        }));
        return p.pix();
    }

    private Group makeNumbersPage(int contentWidth) {
        Pixl p = new Pixl(10, 0);
        ArrayList<Actor> sections = new ArrayList<Actor>();
        for (int side = 0; side < 2; ++side) {
            Pixl left = new Pixl(1);
            Pixl right = new Pixl(1);
            ArrayList<Stat> stats = new ArrayList<Stat>();
            for (Stat s : this.allMergedStats.values()) {
                if (!s.showInAlmanac(side)) continue;
                stats.add(s);
            }
            Collections.sort(stats, new Comparator<Stat>(){

                @Override
                public int compare(Stat o1, Stat o2) {
                    return o1.getOrder() - o2.getOrder();
                }
            });
            for (Stat s : stats) {
                left.text(s.getNameForDisplay()).row();
                right.text(s.getValueForDisplay()).row();
            }
            Group l = left.pix(8);
            Group r = right.pix(8);
            Group a = new Pixl(3).actor(l).gap(10).actor(r).pix();
            sections.add(a);
        }
        p.listActor(contentWidth, sections);
        StandardButton reset = new StandardButton("[red]Reset Stats");
        reset.setRunnable(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pip);
                ChoiceDialog second = new ChoiceDialog("[red]Reset stats?[n][nh]This is permanent[n][nh][purple]Includes[n]-current saves[n]-run history[n]-pick rates[n]-probably more", ChoiceDialog.ChoiceNames.RedYes, new Runnable(){

                    @Override
                    public void run() {
                        Main.self().masterStats.resetAllStatsButNotAchievements();
                        ContextConfig.CLEAR_ALL_SAVES();
                        Main.self().setScreen(Main.getCurrentScreen().copy());
                        Main.getCurrentScreen().showDialog("[green]All stats reset permanently[n][purple]I hope you are happy", Colours.red);
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        Main.getCurrentScreen().pop(ChoiceDialog.class);
                    }
                });
                Main.getCurrentScreen().push(second, 0.7f);
                Tann.center(second);
            }
        });
        p.row(5).actor(reset);
        return p.pix();
    }

    private Group makeLeaderboard(final Leaderboard selected, final int contentWidth) {
        Pixl p = new Pixl(4).forceWidth(contentWidth);
        p.text("[blue]Online Leaderboards").row();
        final HashMap leaderboardMap = new HashMap();
        ArrayList<String> keys = new ArrayList<String>();
        for (Leaderboard l : LeaderboardBlob.all) {
            if (UnUtil.isLocked(l) || l.isUnavailable()) continue;
            String name = l.getSuperName();
            if (leaderboardMap.get(name) == null) {
                leaderboardMap.put(name, new ArrayList());
                keys.add(name);
            }
            ((List)leaderboardMap.get(name)).add(l);
        }
        for (final String s : keys) {
            StandardButton sb = new StandardButton(s);
            p.actor(sb, contentWidth - 10);
            sb.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Color c = Colours.yellow;
                    int gap = 4;
                    Pixl modal = new Pixl(gap, gap + 1).border(c);
                    String MODAL_NAME = "leaderboard_modal";
                    List lbs = (List)leaderboardMap.get(s);
                    ArrayList<Actor> lButts = new ArrayList<Actor>();
                    for (final Leaderboard l : lbs) {
                        StandardButton tb = l.makeTextButton();
                        lButts.add(tb);
                        tb.setRunnable(new Runnable(){

                            @Override
                            public void run() {
                                Main.getCurrentScreen().pop("leaderboard_modal");
                                Sounds.playSound(Sounds.pipSmall);
                                StuffPage.this.showThing(StuffPage.this.makeLeaderboard(l, contentWidth));
                            }
                        });
                        if (l != selected) continue;
                        tb.setBorder(Colours.light);
                    }
                    modal.actor(Tann.layoutMinArea(lButts, gap));
                    Group a = modal.pix();
                    a.setName("leaderboard_modal");
                    Main.getCurrentScreen().pushAndCenter(a, 0.8f);
                    return true;
                }
            });
        }
        p.row();
        if (selected != null) {
            selected.clearCache();
            if (selected.canSubmitBetterScore()) {
                p.actor(selected.getSubmitHighscoreButton()).row();
            }
            LeaderboardDisplay ld = new LeaderboardDisplay(selected);
            p.actor(ld);
        }
        return p.pix();
    }

    private Group makeRunHistory(Mode selected) {
        Pixl mainPixl = new Pixl(4);
        int modesAdded = 0;
        RunHistoryStore rhs = Main.self().masterStats.getRunHistoryStore();
        for (final Mode mode : Mode.getPlayableModes()) {
            if (UnUtil.isLocked(mode) || rhs.getRuns(mode).size() == 0) continue;
            StandardButton tb = new StandardButton(mode.getTextButtonName());
            tb.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Sounds.playSound(Sounds.pip);
                    StuffPage.this.showThing(StuffPage.this.makeRunHistory(mode));
                    return true;
                }
            });
            mainPixl.actor(tb, (int)(this.getWidth() * 0.9f));
            ++modesAdded;
        }
        if (modesAdded == 0) {
            mainPixl.text("[purple]no runs logged :(");
        }
        if (selected != null) {
            mainPixl.row();
            List<RunHistory> runs = rhs.getRuns(selected);
            if (runs.size() == 0) {
                mainPixl.row(7).text("Hmm, bugged?");
            } else {
                List<RunHistory> data = rhs.getRuns(selected);
                mainPixl.actor(RunHistory.makeGroup(data));
            }
        }
        return mainPixl.pix();
    }

    @Override
    public void onFocus(String defaultSidebar) {
        super.onFocus(defaultSidebar);
        Main.stage.setScrollFocus(this.contentPanel);
    }

    public static enum StuffSection implements Unlockable
    {
        Options(Colours.text),
        Credits(CreditsPanel.CREDITS_COL),
        Jukebox(Colours.orange),
        Online(Colours.blue),
        Graph(Colours.red),
        Patch(Colours.purple),
        Numbers(Colours.grey);

        final Color col;

        private StuffSection(Color col) {
            this.col = col;
        }

        private StuffSection() {
            this(Colours.grey);
        }

        public String getColourTaggedString() {
            return TextWriter.getTag(this.col) + this.name();
        }

        @Override
        public Actor makeUnlockActor(boolean big) {
            return UnUtil.makeDefaultUnlock(this.getColourTaggedString(), big);
        }

        @Override
        public TextureRegion getAchievementIcon() {
            return null;
        }

        @Override
        public String getAchievementIconString() {
            return "j";
        }
    }
}

