/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.sidebar;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.tann.dice.screens.dungeon.panels.book.TopTab;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import java.util.ArrayList;
import java.util.List;

public class SideBar
extends Group {
    private List<TopTab> items = new ArrayList<TopTab>();
    public static final int DEFAULT_WIDTH = 45;
    public static final int DEFAULT_HEIGHT = 18;
    boolean drawBorder;

    public SideBar() {
        this.setTransform(false);
        this.setTouchable(Touchable.childrenOnly);
    }

    public void addItem(TopTab item) {
        this.items.add(item);
    }

    public List<TopTab> getItems() {
        return this.items;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.drawBorder) {
            Draw.fillActor(batch, this, Colours.dark, Colours.grey, 1);
        }
        super.draw(batch, parentAlpha);
    }

    public void highlightAssoc(Object identifier) {
        for (TopTab item : this.getItems()) {
            item.focusedPage(identifier);
        }
    }

    public void highlightItem(TopTab sbi) {
        for (TopTab item : this.getItems()) {
            item.setFocused(sbi == item);
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public void layoutHori(int width, int height) {
        int widthPerButton = this.gwpbh(this.items.size(), width);
        int currentY = 0;
        int currentX = 0;
        int rows = 1;
        if (widthPerButton < 40) {
            widthPerButton = this.gwpbh((int)Math.ceil((float)this.items.size() / 2.0f), width);
            currentY += height - 1;
            rows = 2;
        }
        ArrayList<TopTab> tabs = new ArrayList<TopTab>();
        tabs.addAll(this.items);
        for (int i = 0; i < this.items.size(); ++i) {
            TopTab it = this.items.get(i);
            it.setSize(widthPerButton, height);
            this.addActor(it);
            if (currentX + widthPerButton > width) {
                currentX = 0;
                currentY -= height - 1;
            }
            it.setPosition(currentX, currentY);
            currentX += widthPerButton - 1;
        }
        int perRow = (int)Math.ceil((float)this.items.size() / (float)rows);
        int remainder = perRow * rows - this.items.size();
        for (int i = 0; i < remainder; ++i) {
            TopTab it = new TopTab("abc", "[grey]x");
            tabs.add(it);
            it.setSize(widthPerButton, height);
            this.addActor(it);
            it.setPosition(currentX, currentY);
            currentX += widthPerButton - 1;
        }
        int extraPixels = width - widthPerButton * perRow + (perRow - 1);
        if (extraPixels > 0) {
            for (int i = perRow - 1; i < tabs.size(); i += perRow) {
                TopTab tt = (TopTab)tabs.get(i);
                tt.setWidth(tt.getWidth() + (float)extraPixels);
            }
        }
        this.setSize(width, height * rows - (rows - 1) * 1);
    }

    private int gwpbh(int size, int width) {
        return Math.min((width + size - 1) / size, 999);
    }

    public void layoutVerti(int height) {
        int maxh = 5000;
        int heightPerButton = Math.min((height + this.items.size() - 1) / this.items.size(), 5000);
        int extraHeight = height - heightPerButton * this.items.size() + (this.items.size() - 1);
        int currentY = 0;
        float extraFactor = 0.0f;
        for (int i = this.items.size() - 1; i >= 0; --i) {
            TopTab it = this.items.get(i);
            it.setSize(45.0f, heightPerButton);
            float naf = (float)(this.items.size() - i) / (float)this.items.size() * (float)extraHeight;
            if ((int)naf != (int)extraFactor) {
                it.setHeight(it.getHeight() + 1.0f);
            }
            extraFactor = naf;
            this.addActor(it);
            it.setY(currentY);
            currentY = (int)((float)currentY + (it.getHeight() - 1.0f));
        }
        int hh = heightPerButton * this.items.size() - (this.items.size() - 1);
        hh = currentY + 1;
        this.setSize(45.0f, hh);
    }

    public void setDrawBorder(boolean b) {
        this.drawBorder = b;
    }
}

