/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.simpleStrike;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.simpleStrike.SimpleStrike;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.LightningActor;
import com.tann.dice.util.Tann;

public class ElectroBladeActor
extends SimpleStrike {
    private static final float SPARK_DURATION = 0.1f;

    public ElectroBladeActor(Ent target, int damage, TextureRegion image, float impactTime, float stickTime, float retractTime) {
        super(target, damage, image, impactTime, stickTime, retractTime);
    }

    @Override
    protected void impact() {
        Sounds.playSound(Sounds.lightning);
        float yVariance = this.target.getEntPanel().getHeight() / 2.0f + 40.0f;
        int sparks = 8;
        for (int i = 0; i < sparks; ++i) {
            LightningActor lightningActor = new LightningActor(this.getX(), this.getY(), this.getX() + Tann.random(40.0f) + 40.0f, this.getY() + (Tann.random(yVariance / 2.0f) + yVariance / 2.0f) * (float)(Tann.half() ? 1 : -1), 5.0f, 5.0f);
            DungeonScreen.get().addActor(lightningActor);
            lightningActor.setColor(Colours.withAlpha(Tann.half() ? Colours.light : Colours.blue, 0.0f));
            lightningActor.addAction(Actions.sequence((Action)Actions.delay((float)i / (float)sparks * 0.1f), (Action)Actions.alpha(1.0f), Tann.fadeAndRemove(0.4f)));
        }
    }
}

