/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.tutorial;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.gameplay.PlayerRollingPhase;
import com.tann.dice.gameplay.phase.gameplay.TargetingPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPhase;
import com.tann.dice.gameplay.progress.StatSnapshot;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialInfo;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialManager;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialQuest;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.Flasher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TutorialItem
extends Group {
    protected boolean complete;
    final int priority;

    public TutorialItem() {
        this(0);
    }

    public TutorialItem(int priority) {
        this.priority = priority;
        this.setTransform(false);
    }

    void layout() {
        Actor a;
        this.clearChildren();
        Pixl p = new Pixl(1).forceWidth(83);
        String text = this.getDisplayText();
        if (text != null) {
            p.text(this.getDisplayText());
        }
        if ((a = this.getActor()) != null) {
            p.actor(a);
        }
        Tann.become(this, p.pix(8));
    }

    protected Actor getActor() {
        return null;
    }

    protected abstract String getDisplayText();

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    public void markCompleted() {
        this.complete = true;
        this.layout();
        this.addActor(new Flasher(this, Colours.light));
    }

    public void newSnapshot(Snapshot snapshot) {
    }

    public void onRoll(List<Ent> heroes) {
    }

    public void newStatsSnapshot(StatSnapshot ss) {
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isValid(FightLog fightLog) {
        return true;
    }

    public void onLock(List<Ent> heroes) {
    }

    public void onAction(TutorialManager.TutorialAction type, Object arg) {
    }

    public static Map<Class<? extends Phase>, List<TutorialItem>> makeAll() {
        Comparator<TutorialItem> comp = new Comparator<TutorialItem>(){

            @Override
            public int compare(TutorialItem o1, TutorialItem o2) {
                return o1.getPriority() - o2.getPriority();
            }
        };
        HashMap<Class<? extends Phase>, List<TutorialItem>> tutorialMap = new HashMap<Class<? extends Phase>, List<TutorialItem>>();
        ArrayList<TutorialItem> roll = new ArrayList<TutorialItem>();
        roll.addAll(TutorialInfo.makeRollingPhase());
        roll.addAll(TutorialQuest.makeRollingPhase());
        Collections.sort(roll, comp);
        tutorialMap.put(PlayerRollingPhase.class, roll);
        ArrayList<TutorialItem> target = new ArrayList<TutorialItem>();
        target.addAll(TutorialInfo.makeTargetingPhase());
        target.addAll(TutorialQuest.makeTargetingPhase());
        Collections.sort(target, comp);
        tutorialMap.put(TargetingPhase.class, target);
        ArrayList<TutorialItem> levelEnd = new ArrayList<TutorialItem>();
        levelEnd.addAll(TutorialInfo.makeLevelEndPhase());
        levelEnd.addAll(TutorialQuest.makeLevelEndPhase());
        levelEnd.addAll(Main.self().control.makeTutorialLevelEnd());
        Collections.sort(levelEnd, comp);
        tutorialMap.put(LevelEndPhase.class, levelEnd);
        return tutorialMap;
    }

    private int getPriority() {
        return this.priority;
    }

    public boolean isComplex() {
        this.layout();
        return this.getHeight() > 17.0f;
    }

    public void onSlideAway() {
    }

    public String getSortText() {
        if (this.getDisplayText() != null) {
            return this.getDisplayText();
        }
        if (this.getActor().getName() == null) {
            throw new RuntimeException("bad tutorial");
        }
        return this.getActor().getName();
    }

    public void loadIn() {
    }
}

