/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.generalPanels;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.entPanel.ItemHeroPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.screens.generalPanels.PartyManagementPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.AlternativePop;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.PostPop;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.Glowverlay;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.resolver.ItemResolver;
import java.util.ArrayList;
import java.util.List;

public class InventoryPanel
extends Group
implements PostPop,
AlternativePop {
    public static final int down = 3;
    private static final int PANEL_SIZE = 14;
    private static final int gap = 1;
    private static InventoryPanel self;
    private Actor invTitle;
    Actor zoom;

    public static InventoryPanel get() {
        if (self == null) {
            self = new InventoryPanel();
        }
        return self;
    }

    public static int getAcross() {
        return PartyManagementPanel.tinyPanels ? 4 : 6;
    }

    public static void resetSingleton() {
        self = null;
    }

    private InventoryPanel() {
        this.setSize(14 * InventoryPanel.getAcross() + 1 * (InventoryPanel.getAcross() + 1), 46.0f);
        this.reset();
        this.setTransform(false);
    }

    public void reset() {
        TextWriter tw;
        if (DungeonScreen.get() == null) {
            return;
        }
        this.clearChildren();
        List<Item> items = DungeonScreen.get().getDungeonContext().getParty().getItems(false);
        ArrayList<Glowverlay> glows = new ArrayList<Glowverlay>();
        for (int i = 0; i < items.size(); ++i) {
            Glowverlay glowverlay;
            Item item = items.get(i);
            ItemHeroPanel ep = new ItemHeroPanel(item, null);
            this.addActor(ep);
            ep.setPosition(i % InventoryPanel.getAcross() * 15 + 1, i / InventoryPanel.getAcross() * 15 + 1);
            if (item.isForceEquip()) {
                glowverlay = new Glowverlay(Colours.red);
                ep.addActor(glowverlay);
                glows.add(glowverlay);
                continue;
            }
            if (!item.isNew()) continue;
            glowverlay = new Glowverlay();
            ep.addActor(glowverlay);
            glows.add(glowverlay);
        }
        Main.getCurrentScreen().setGlowverlays(glows);
        TextWriter tw2 = new TextWriter("[grey]Items", 999, Colours.purple, 3);
        this.addActor(tw2);
        tw2.setPosition((int)(this.getWidth() / 2.0f - tw2.getWidth() * 2.0f / 3.0f), (int)(this.getHeight() - 1.0f));
        this.invTitle = tw2;
        Party p = DungeonScreen.get().partyManagementPanel.fightLog.getContext().getParty();
        if (!p.hasAnyItems()) {
            tw = new TextWriter("[purple]no items :(");
            tw.setPosition((int)(this.getWidth() / 2.0f - tw.getWidth() / 2.0f), (int)(this.getHeight() / 2.0f - tw.getHeight() / 2.0f));
            this.addActor(tw);
        } else if (!Main.getSettings().isHasEquipped()) {
            tw = new TextWriter("[yellow]drag to equip");
            tw.setTouchable(Touchable.disabled);
            tw.toBack();
            tw.setPosition((int)(this.getWidth() / 2.0f - tw.getWidth() / 2.0f), (int)(this.getHeight() / 2.0f - tw.getHeight() / 2.0f));
            this.addActor(tw);
        }
        this.setTouchable(Touchable.childrenOnly);
        this.getInvTitle().addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (DungeonScreen.isWish()) {
                    new ItemResolver(){

                        @Override
                        public void resolve(Item item) {
                            Sounds.playSound(Sounds.magic);
                            DungeonScreen ds = DungeonScreen.get();
                            if (ds == null) {
                                return;
                            }
                            ds.getDungeonContext().getParty().addItem(item);
                        }
                    }.activate(Mode.WISH.wishFor("item", Colours.grey));
                }
                return true;
            }
        });
        if (this.zoom != null) {
            this.addActor(this.zoom);
            this.setZoomPos();
        }
    }

    private void setZoomPos() {
        this.zoom.toBack();
        Actor a = InventoryPanel.get().getInvTitle();
        this.zoom.setX(a.getX(16) - 1.0f);
        this.zoom.setY(a.getY());
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(Colours.dark);
        Draw.fillActor(batch, this);
        batch.setColor(Colours.purple);
        PartyManagementPanel pmp = DungeonScreen.get().partyManagementPanel;
        if (pmp.isDragging()) {
            batch.setColor(Colours.light);
        }
        Draw.drawRectangle(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 1);
        super.draw(batch, parentAlpha);
    }

    @Override
    public void postPop() {
        Sounds.playSound(Sounds.pop);
    }

    @Override
    public boolean alternativePop() {
        Tann.slideAway(this, Tann.TannPosition.Top, true);
        return true;
    }

    public Actor getInvTitle() {
        return this.invTitle;
    }

    public void addZoom(final Party prty) {
        this.zoom = new Pixl(0, 1).border(Colours.purple).actor(new ImageActor(Images.zoom2, Colours.grey)).pix();
        this.addActor(this.zoom);
        this.setZoomPos();
        this.zoom.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Sounds.playSound(Sounds.pip);
                Pixl p = new Pixl(3, 3).border(Colours.grey);
                int WIDTH = (int)((float)Main.width * 0.7f);
                int HEIGHT = (int)((float)Main.height * 0.7f);
                boolean hasBoth = prty.getItems(true).size() > 0 && prty.getItems(false).size() > 0;
                for (boolean eqpt : Tann.BOTH) {
                    List<Item> items = prty.getItems(eqpt);
                    if (items.isEmpty()) continue;
                    if (hasBoth) {
                        p.text("[text]" + (eqpt ? "equipped" : "inventory")).row(3);
                    }
                    for (Item item : items) {
                        p.actor(new ItemPanel(item, false), WIDTH);
                    }
                    if (eqpt) continue;
                    p.row(10);
                }
                Group a = p.pix();
                ScrollPane scrollPane = Tann.makeScrollpane(a);
                Tann.selfPop(scrollPane);
                scrollPane.setWidth(Math.max(a.getWidth() + 6.0f, scrollPane.getWidth()));
                scrollPane.setHeight(Math.min(a.getHeight(), (float)HEIGHT));
                Main.getCurrentScreen().push(scrollPane, true, true, true, 0.8f);
                Tann.center(scrollPane);
                return true;
            }
        });
    }
}

