/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.graph;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.graph.GraphUpdate;
import com.tann.dice.util.Colours;
import com.tann.dice.util.DebugUtilsUseful;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.LineActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class GraphUtils {
    public static Actor makeWidth(int width, GraphUpdate graphUpdate) {
        return GraphUtils.make(new ArrayList<EntSide>(Arrays.asList(ESB.dmg.val(1))), (width - 40) / 30, true, false, graphUpdate);
    }

    public static Actor make(final List<EntSide> active, final int maxPips, final boolean hero, boolean startPressed, final GraphUpdate graphUpdate) {
        Pixl p = new Pixl(2);
        p.actor(GraphUtils.makeGraph(active, maxPips, hero)).row(27);
        if (active.size() > 0) {
            for (final EntSide es : active) {
                ImageActor ia = new ImageActor(es.getTexture());
                ia.addListener(new TannListener(){

                    @Override
                    public boolean action(int button, int pointer, float x, float y) {
                        int index = GraphUtils.indexOf(active, es);
                        if (index != -1) {
                            active.remove(index);
                            graphUpdate.newGraph(GraphUtils.make(active, maxPips, hero, false, graphUpdate));
                        }
                        return true;
                    }

                    @Override
                    public boolean info(int button, float x, float y) {
                        Explanel a = new Explanel(es, null);
                        Main.getCurrentScreen().push(a);
                        Tann.center(a);
                        return true;
                    }
                });
                Group cont = new Pixl().border(GraphUtils.hashCol(es)).actor(ia).pix();
                p.actor(cont);
            }
        }
        StandardButton plus = new StandardButton("+");
        p.actor(plus);
        Runnable tl = new Runnable(){

            @Override
            public void run() {
                EntSide es;
                Pixl popup = new Pixl(2).border(Colours.dark, Colours.grey, 1);
                List<EntSide> list = EntSidesLib.getAllSidesWithValue();
                for (int i = list.size() - 1; i >= 0; --i) {
                    es = list.get(i);
                    if (!es.isGeneric()) continue;
                    list.remove(i);
                }
                Collections.sort(list, new Comparator<EntSide>(){

                    @Override
                    public int compare(EntSide o1, EntSide o2) {
                        int count2;
                        Eff e1 = o1.getBaseEffect();
                        Eff e2 = o2.getBaseEffect();
                        if (e1.isBasic() != e2.isBasic()) {
                            return e1.isBasic() ? -1 : 1;
                        }
                        if (o1.size != o2.size) {
                            if (o1.size == EntSize.small) {
                                return 1;
                            }
                            if (o2.size == EntSize.small) {
                                return -1;
                            }
                            return o1.size.getPixels() - o2.size.getPixels();
                        }
                        EffType t1 = e1.getType();
                        EffType t2 = e2.getType();
                        if (t2 != t1) {
                            return t1.ordinal() - t2.ordinal();
                        }
                        int count1 = DebugUtilsUseful.getUses(o1, true);
                        if (count1 != (count2 = DebugUtilsUseful.getUses(o2, true))) {
                            return count2 - count1;
                        }
                        return 0;
                    }
                });
                Iterator<EntSide> i = list.iterator();
                while (i.hasNext()) {
                    Actor a = es.makeBasicSideActor(GraphUtils.indexOf(active, es = i.next()) == -1 ? 0 : 3, false, null);
                    a.addListener(new TannListener(){

                        @Override
                        public boolean action(int button, int pointer, float x, float y) {
                            int index = GraphUtils.indexOf(active, es);
                            if (index == -1) {
                                active.add(es);
                            } else {
                                active.remove(index);
                            }
                            Main.getCurrentScreen().popAllLight();
                            Main.getCurrentScreen().popSingleMedium();
                            graphUpdate.newGraph(GraphUtils.make(active, maxPips, hero, true, graphUpdate));
                            return true;
                        }

                        @Override
                        public boolean info(int button, float x, float y) {
                            Explanel a = new Explanel(es, null);
                            Main.getCurrentScreen().push(a);
                            Tann.center(a);
                            return true;
                        }
                    });
                    popup.actor(a, (float)Main.width * 0.7f);
                }
                Group a = popup.pix();
                final ScrollPane sp = Tann.makeScrollpane(a);
                sp.setSize(a.getWidth() + 6.0f, (float)Main.height * 0.8f);
                sp.addListener(new TannListener(){

                    @Override
                    public boolean action(int button, int pointer, float x, float y) {
                        Main.getCurrentScreen().pop(sp);
                        return true;
                    }
                });
                Main.getCurrentScreen().push(sp);
                Tann.center(sp);
            }
        };
        plus.setRunnable(tl);
        if (startPressed) {
            tl.run();
        }
        StandardButton heroToggle = new StandardButton(hero ? "hero" : "monster");
        heroToggle.setRunnable(new Runnable(){

            @Override
            public void run() {
                graphUpdate.newGraph(GraphUtils.make(active, maxPips, !hero, false, graphUpdate));
            }
        });
        p.row().actor(heroToggle);
        Group a = p.pix();
        a.setName("graph");
        return a;
    }

    private static int indexOf(List<EntSide> list, EntSide es) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).same(es)) continue;
            return i;
        }
        return -1;
    }

    private static Actor makeGraph(List<EntSide> active, int maxPips, boolean hero) {
        int gridSize = 30;
        int pipWidth = 30;
        int valHeight = 30;
        int maxVal = 0;
        for (EntSide es : active) {
            maxVal = (int)Math.max((double)maxVal, Math.ceil(es.withValue(maxPips).getEffectTier(HeroTypeUtils.byName("veteran"))));
        }
        maxVal = Math.min(maxVal, 30);
        Actor leftBar = GraphUtils.makeLeftBar(maxVal, 30, Colours.orange);
        Actor bottomBar = GraphUtils.makeBottomBar(maxPips, 30);
        Group g = new Group(){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                Draw.fillActor(batch, this, Colours.dark, Colours.grey, 1);
                super.draw(batch, parentAlpha);
            }
        };
        g.setSize(bottomBar.getWidth(), leftBar.getHeight());
        g.addActor(leftBar);
        leftBar.setPosition(-leftBar.getWidth(), 0.0f);
        g.addActor(bottomBar);
        bottomBar.setPosition(0.0f, -bottomBar.getHeight());
        GraphUtils.addGridLines(g, 30, maxPips, 30, maxVal);
        for (EntSide es : active) {
            GraphUtils.addSideToGraph(g, es, maxPips, 30, 30, hero);
        }
        g = new Pixl(0).text("[orange]Calc'd[n]Value").gap(12).actor(g).pix();
        TextWriter pips = new TextWriter("Pips");
        g.addActor(pips);
        pips.setPosition((int)(g.getWidth() / 2.0f - pips.getWidth() / 2.0f), -pips.getHeight() - 15.0f);
        return g;
    }

    private static void addGridLines(Group g, int pipWidth, int maxPips, int valHeight, int maxVal) {
        Rectactor ra;
        int i;
        Color col = Colours.withAlpha(Colours.light, 0.06f).cpy();
        for (i = 0; i < maxVal; ++i) {
            ra = new Rectactor((int)g.getWidth(), 1, col);
            g.addActor(ra);
            ra.setY(i * valHeight);
        }
        for (i = 0; i < maxPips; ++i) {
            ra = new Rectactor(1, (int)g.getHeight(), col);
            g.addActor(ra);
            ra.setX(i * pipWidth);
        }
    }

    public static Color hashCol(EntSide es) {
        TextureAtlas.AtlasRegion ar = (TextureAtlas.AtlasRegion)es.getTexture();
        return Tann.getHashColour(ar.name.hashCode());
    }

    private static void addSideToGraph(Group graph, EntSide es, int maxPips, int pipWidth, int valHeight, boolean hero) {
        EntType[] types = hero ? new EntType[]{HeroTypeUtils.byName("thief"), HeroTypeUtils.byName("guardian"), HeroTypeUtils.byName("veteran")} : new EntType[]{MonsterTypeLib.byName("bones")};
        boolean cantrippy = es.withValue(1).getExtraFlatEffectTier(types[0]) > 0.0f;
        for (int lv = 0; lv < types.length; ++lv) {
            float prevPower = 0.0f;
            Color col = GraphUtils.hashCol(es);
            col.a = 1.0f - (float)lv * 0.3f;
            for (int pipNum = 0; pipNum <= maxPips; ++pipNum) {
                EntSide test = es.withValue(pipNum);
                float power = test.getEffectTier(types[lv]);
                if (pipNum > 0) {
                    LineActor line = new LineActor((pipNum - 1) * pipWidth, prevPower * (float)valHeight, pipNum * pipWidth, power * (float)valHeight);
                    line.setColor(col);
                    graph.addActor(line);
                }
                prevPower = power;
            }
            if (!cantrippy) continue;
            float prevCantrip = 0.0f;
            Color cantripCol = col.cpy().lerp(Colours.pink, 0.6f);
            for (int pipNum = 0; pipNum <= maxPips; ++pipNum) {
                EntSide test = es.withValue(pipNum);
                float power = test.getExtraFlatEffectTier(types[lv]);
                if (pipNum > 0) {
                    LineActor line = new LineActor((pipNum - 1) * pipWidth, prevCantrip * (float)valHeight, pipNum * pipWidth, power * (float)valHeight);
                    line.setColor(cantripCol);
                    graph.addActor(line);
                }
                prevCantrip = power;
            }
        }
    }

    private static Actor makeBottomBar(int maxPips, int pipDist) {
        Pixl bottomBar = new Pixl();
        for (int i = 0; i <= maxPips; ++i) {
            Rectactor rect = new Rectactor(1, 4, Colours.light);
            Group g = Tann.makeGroup(rect);
            TextWriter tw = new TextWriter(i + "");
            g.addActor(tw);
            tw.setPosition((int)(-tw.getWidth() / 2.0f), -tw.getHeight() - 2.0f);
            bottomBar.actor(g);
            if (i >= maxPips) continue;
            bottomBar.gap(pipDist - (int)g.getWidth());
        }
        return bottomBar.pix();
    }

    private static Actor makeLeftBar(int maxVal, int valHeight, Color col) {
        Pixl leftBar = new Pixl();
        for (int i = maxVal; i >= 0; --i) {
            Rectactor rect = new Rectactor(4, 1, col);
            Group g = Tann.makeGroup(rect);
            TextWriter tw = new TextWriter(TextWriter.getTag(col) + i);
            g.addActor(tw);
            tw.setPosition(-tw.getWidth() - 2.0f, (int)(-tw.getHeight() / 2.0f));
            leftBar.actor(g);
            if (i <= 0) continue;
            leftBar.row((int)((float)valHeight - g.getHeight()));
        }
        return leftBar.pix(16);
    }
}

