/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.Main;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageUtils {
    public static final List<TextureAtlas.AtlasRegion> genImages = Tann.getRegionsStartingWith("portrait/hero/special/generated/");
    public static Map<TextureRegion, TextureRegion> cachedMap = new HashMap<TextureRegion, TextureRegion>();

    public static void clearCaches() {
        cachedMap = new HashMap<TextureRegion, TextureRegion>();
    }

    public static TextureRegion get2DIfPossible(TextureRegion tex) {
        if (OptionLib.DISABLE_2D_3D_IMAGE.c()) {
            return tex;
        }
        TextureRegion result = cachedMap.get(tex);
        if (result != null) {
            return result;
        }
        if (tex instanceof TextureAtlas.AtlasRegion) {
            TextureAtlas.AtlasRegion ar = (TextureAtlas.AtlasRegion)tex;
            TextureRegion tmp = ImageUtils.loadExtNull("3dlink/" + ar.name);
            if (tmp != null) {
                cachedMap.put(tex, tmp);
                return tmp;
            }
            TannLog.error("missing linked for " + ar.name);
        }
        TannLog.error("failed to get 2d for " + tex);
        cachedMap.put(tex, tex);
        return tex;
    }

    public static TextureAtlas.AtlasRegion loadArExt(String s) {
        TextureRegion tr = ImageUtils.loadExt(s);
        if (tr instanceof TextureAtlas.AtlasRegion) {
            return (TextureAtlas.AtlasRegion)tr;
        }
        return null;
    }

    public static TextureRegion loadExtNull(String regionName) {
        return Main.atlas.findRegion(regionName);
    }

    public static TextureRegion loadExt(String name) {
        return ImageUtils.loadExt(Main.atlas, name);
    }

    public static TextureRegion loadExtBig(String name) {
        return ImageUtils.loadExt(Main.atlas_big, name);
    }

    public static TextureRegion loadExt3d(String name) {
        return ImageUtils.loadExt(Main.atlas_3d, name);
    }

    private static TextureRegion loadExt(TextureAtlas atlas, String name) {
        return Images.load(atlas, name);
    }

    public static TextureRegion loadExt3dNull(String s) {
        return Main.atlas_3d.findRegion(s);
    }
}

