/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.sound.music;

import com.tann.dice.Main;
import com.tann.dice.statics.sound.music.MusicData;
import com.tann.dice.statics.sound.music.MusicManager;
import com.tann.dice.statics.sound.music.MusicType;
import com.tann.dice.statics.sound.music.Musician;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MusicBlob {
    static final String SUFFIX = Main.self().control.getMusicExtension();

    static List<MusicData> getData() {
        return Arrays.asList(new MusicData("louigi verona/Ancient Books of Magic" + SUFFIX, 84.789f, MusicType.Title), new MusicData("louigi verona/Dark Enchantments" + SUFFIX, 93.607f, MusicType.Lair, MusicType.Catacombs, MusicType.Pit), new MusicData("louigi verona/Deadly Encounter" + SUFFIX, 57.935f, MusicType.Dungeon, MusicType.Forest), new MusicData("louigi verona/Bounty Hunters" + SUFFIX, 127.05f, MusicType.Forest, MusicType.Lair), new MusicData("louigi verona/Spellcasters Galore" + SUFFIX, 90.948f, MusicType.Forest, MusicType.Dungeon), new MusicData("louigi verona/War Machines" + SUFFIX, 68.999f, MusicType.Pit, MusicType.Dungeon), new MusicData("cold sanctum/LINGERING DESOLATE GLOOM" + SUFFIX, 87.797f, MusicType.Title), new MusicData("cold sanctum/CONJURING SINISTER WIZARDRY" + SUFFIX, 94.119995f, MusicType.Catacombs, MusicType.Pit), new MusicData("roho/Swiftsoles v3" + SUFFIX, 124.8f, MusicType.Forest, MusicType.Dungeon, MusicType.Lair).loop(2, 6.85f), new MusicData("ziggurath/Assassins_ Dirge" + SUFFIX, 132.0f, MusicType.Lair, MusicType.Catacombs).loop(2, 0.2f), new MusicData("ziggurath/Gemstones and Stratagems" + SUFFIX, 95.999f, MusicType.Lair, MusicType.Dungeon).loop(2, 21.4f), new MusicData("ziggurath/Steel Wins Battles" + SUFFIX, 128.0f, MusicType.Forest, MusicType.Dungeon).loop(2, 18.55f), new MusicData("ziggurath/Veteran of 1000 Rolls" + SUFFIX, 121.29f, MusicType.Forest, MusicType.Dungeon).loop(2, 4.5f), new MusicData("aleksander/Into The Depths" + SUFFIX, 64.931f, MusicType.Dungeon, MusicType.Catacombs, MusicType.Pit).loop(2, 0.0f), new MusicData("aleksander/Next Battle Awaits" + SUFFIX, 25.352f, MusicType.Dungeon, MusicType.Lair, MusicType.Catacombs), new MusicData("aleksander/Dicing Opponents" + SUFFIX, 88.393f, MusicType.Forest, MusicType.Dungeon).loop(2, 0.0f), new MusicData("aleksander/Defense Ready" + SUFFIX, 95.065f, MusicType.Lair, MusicType.Pit).loop(2, 0.2f).fadeSpeed(0.5f), new MusicData("andrew goodwin/What The Smoke Conceals" + SUFFIX, 121.14f, MusicType.Forest, MusicType.Lair).loop(2, 0.0f), new MusicData("andrew goodwin/Black Castle" + SUFFIX, 94.913f, MusicType.Dungeon, MusicType.Catacombs, MusicType.Pit).loop(2, 0.0f), new MusicData("andrew goodwin/Withering Thoughts" + SUFFIX, 145.043f, MusicType.Lair, MusicType.Catacombs, MusicType.Title).loop(2, 0.0f), new MusicData("andrew goodwin/No Turning Back" + SUFFIX, 109.71f, MusicType.Dungeon, MusicType.Catacombs).loop(2, 1.62f), new MusicData("andrew goodwin/The Witches Castle" + SUFFIX, 93.595f, MusicType.Dungeon, MusicType.Catacombs).loop(2, 0.0f));
    }

    public static List<Musician> loadMusicians(List<MusicData> dataLust) {
        HashMap musicianToTrack = new HashMap();
        for (MusicData musicDatum : dataLust) {
            String path = musicDatum.path;
            String[] parts = path.split("/");
            String author = parts[0];
            String track = parts[1];
            if (musicianToTrack.get(author) == null) {
                musicianToTrack.put(author, new ArrayList());
            }
            ((List)musicianToTrack.get(author)).add(musicDatum);
        }
        ArrayList<Musician> result = new ArrayList<Musician>();
        ArrayList keys = new ArrayList(musicianToTrack.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String musicianFolderName;
            String name = musicianFolderName = (String)iterator.next();
            String path = musicianFolderName;
            String url = "unset";
            switch (name) {
                case "andrew goodwin": {
                    url = "https://www.andrewgoodwincomposer.com/";
                    break;
                }
                case "aleksander": {
                    url = "https://www.aleksanderzablocki.com/";
                    name = "Aleksander Zab[p][zablocki][p]ocki";
                    break;
                }
                case "tann": {
                    url = "https://tann.fun";
                    break;
                }
                case "ziggurath": {
                    url = "https://www.youtube.com/watch?v=T4f_Nf17MbY&list=PLisbFJAT312VD5qpsjOcEe58ObfEt0NQ1";
                    break;
                }
                case "louigi verona": {
                    url = "https://louigiverona.com/?page=about";
                    break;
                }
                case "roho": {
                    url = "https://rosoe.xyz/";
                    name = "ro's[p][roso]";
                    break;
                }
                case "cold sanctum": {
                    url = Main.self().control.stupidAboutLinks() ? "cold sanctum music" : "https://coldsanctum.bandcamp.com/";
                }
            }
            name = Words.capitaliseWords(name);
            result.add(new Musician(name, path, url, (List)musicianToTrack.get(musicianFolderName)));
        }
        return result;
    }

    public static String getMusicianFeature() {
        ArrayList<String> msc = new ArrayList<String>();
        for (Musician loadMusician : MusicManager.getMusicianList()) {
            msc.add(loadMusician.name);
        }
        return Tann.commaList(msc);
    }
}

