/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.sound.music;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.tann.dice.statics.sound.music.MusicData;
import java.util.HashMap;
import java.util.Map;

public class MusicCache {
    static Map<MusicData, Music> pathToMusic = new HashMap<MusicData, Music>();

    static void resetStatics() {
        MusicCache.disposeIfNotNull(pathToMusic);
        pathToMusic = new HashMap<MusicData, Music>();
    }

    public static Music get(MusicData path) {
        return pathToMusic.get(path);
    }

    public static Music getOrLoad(MusicData data) {
        if (MusicCache.get(data) != null) {
            return MusicCache.get(data);
        }
        FileHandle fh = Gdx.files.internal("music/" + data.path);
        if (!fh.exists()) {
            return null;
        }
        Music m = Gdx.audio.newMusic(fh);
        MusicCache.set(data, m);
        return m;
    }

    private static void set(MusicData path, Music music) {
        pathToMusic.put(path, music);
    }

    private static void disposeIfNotNull(Map<MusicData, Music> pathToMusic) {
        if (pathToMusic == null) {
            return;
        }
        for (Music value : pathToMusic.values()) {
            value.dispose();
        }
    }
}

