/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.sound.music;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.titleScreen.TitleScreen;
import com.tann.dice.statics.sound.music.JukeboxUtils;
import com.tann.dice.statics.sound.music.MusicBlob;
import com.tann.dice.statics.sound.music.MusicCache;
import com.tann.dice.statics.sound.music.MusicData;
import com.tann.dice.statics.sound.music.MusicFader;
import com.tann.dice.statics.sound.music.MusicFormat;
import com.tann.dice.statics.sound.music.MusicType;
import com.tann.dice.statics.sound.music.Musician;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class MusicManager {
    private static final float SONG_GAP = 1.4f;
    private static final boolean MUSIC_PRINT = false;
    private static List<MusicData> dataList;
    private static List<Musician> musicianList;
    private static final List<MusicData> playedList;
    private static MusicFader fading;
    private static MusicFader playing;
    private static int failsInARow;
    private static boolean waitingForThread;
    private static boolean waitingBetweenSong;
    private static MusicType currentMusicType;
    static float lastPos;
    static int samePos;

    public static void initMusic() {
        dataList = MusicBlob.getData();
        musicianList = MusicBlob.loadMusicians(dataList);
        MusicManager.preloadMusicIfNecessary();
    }

    public static List<Musician> getMusicianList() {
        return musicianList;
    }

    public static List<MusicData> getDataList() {
        return dataList;
    }

    public static boolean requestSong(MusicData music, boolean bypassOverrides) {
        if (!bypassOverrides && Main.getSettings().isDisabledSong(music)) {
            return false;
        }
        if (MusicManager.alreadyPlaying(MusicCache.get(music))) {
            return false;
        }
        MusicManager.fadeIn(music);
        return true;
    }

    public static boolean isMusicDisabled() {
        return Main.self().control.disableMusic() || dataList.isEmpty() || OptionLib.music.isOff();
    }

    public static boolean isPlaying(boolean innerMusic) {
        if (playing == null) {
            return false;
        }
        if (innerMusic) {
            return MusicManager.playing.m.isPlaying();
        }
        return !MusicManager.playing.stopped;
    }

    private static boolean alreadyPlaying(Music m) {
        return fading != null && MusicManager.fading.m == m || playing != null && MusicManager.playing.m == m;
    }

    private static void fadeIn(final MusicData md) {
        boolean useThread;
        boolean bl = useThread = OptionLib.MUSIC_LOAD_TYPE.c() == 0;
        if (useThread && MusicCache.get(md) == null) {
            if (waitingForThread) {
                return;
            }
            waitingForThread = true;
            new Thread(){

                @Override
                public void run() {
                    final Music m = MusicCache.getOrLoad(md);
                    if (m == null) {
                        TannLog.error("Failed to load " + md);
                        failsInARow++;
                        waitingForThread = false;
                        return;
                    }
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            MusicManager.loadAndPlay(md, m);
                            waitingForThread = false;
                        }
                    });
                    super.run();
                }
            }.start();
        } else {
            Music m = MusicCache.getOrLoad(md);
            if (m == null) {
                TannLog.error("Failed to load " + md);
                ++failsInARow;
            } else {
                MusicManager.loadAndPlay(md, m);
            }
        }
    }

    private static boolean loadAndPlay(MusicData md, Music m) {
        if (fading != null) {
            fading.stop();
        }
        if ((fading = playing) != null) {
            fading.fadeOut();
            playedList.add(MusicManager.fading.md);
        }
        try {
            playing = new MusicFader(md, m);
            playing.play();
            if (OptionLib.SHOW_PLAYING_POPUP.c()) {
                Main.getCurrentScreen().showMusicPopup(JukeboxUtils.getPopupActor(md));
            }
            failsInARow = 0;
            return true;
        }
        catch (GdxRuntimeException gre) {
            TannLog.error("Failed to load " + md);
            ++failsInARow;
            return false;
        }
    }

    public static void checkSongIsValid(boolean manualSelect) {
        if (OptionLib.MUSIC_SELECTION.c() == 0) {
            MusicType mt = MusicManager.getCurrentMusicType();
            if ((manualSelect || mt.forceSwitch && currentMusicType != mt || currentMusicType != null && MusicManager.currentMusicType.forceSwitch && currentMusicType != mt) && (playing == null || !Tann.contains(MusicManager.playing.md.musicTypes, mt))) {
                MusicManager.newZoneNewSong();
            }
            currentMusicType = mt;
        }
    }

    public static void tick(float delta) {
        MusicManager.checkSamePosBug();
        if (Main.frames % 100 == 0) {
            MusicManager.checkForThatOneBug();
        }
        MusicManager.checkSongIsValid(false);
        if (Main.getSettings().isVolumeMuted()) {
            if (playing != null && !playing.isFinished()) {
                playing.stop();
            }
            if (fading != null && !fading.isFinished()) {
                fading.stop();
            }
            playing = null;
            fading = null;
            return;
        }
        if (playing != null && playing.act(delta)) {
            playedList.add(MusicManager.playing.md);
            playing = null;
            waitingBetweenSong = true;
            Tann.delay(1.4f, new Runnable(){

                @Override
                public void run() {
                    if (waitingBetweenSong) {
                        MusicManager.manageNewSongs();
                    }
                }
            });
        }
        if (fading != null && fading.act(delta)) {
            fading = null;
        }
        if (!waitingBetweenSong) {
            MusicManager.manageNewSongs();
        }
    }

    private static void checkSamePosBug() {
        float newPos;
        if (MusicManager.isMusicDisabled()) {
            return;
        }
        float f = newPos = playing == null ? -1.0f : MusicManager.playing.m.getPosition();
        if (newPos == lastPos) {
            ++samePos;
        } else {
            lastPos = newPos;
            samePos = 0;
        }
        if (samePos > 360) {
            TannLog.error("music stuck maybe, attempting to jiggle it");
            samePos = 0;
            MusicManager.standardNextSong();
        }
    }

    private static void checkForThatOneBug() {
        for (MusicData musicDatum : dataList) {
            Music m;
            if (playing != null && musicDatum == MusicManager.playing.md || fading != null && musicDatum == MusicManager.fading.md || (m = MusicCache.get(musicDatum)) == null || !m.isPlaying()) continue;
            m.stop();
            String msg = "Old music still playing: " + musicDatum + " (stopped)";
            TannLog.error(msg);
        }
    }

    private static void manageNewSongs() {
        waitingBetweenSong = false;
        if (waitingForThread) {
            return;
        }
        if (MusicManager.hasFailed()) {
            return;
        }
        if (MusicManager.isPlaying(false) && !MusicManager.isPlaying(true)) {
            MusicManager.standardNextSong();
            return;
        }
        if (playing == null || playing.isFinished()) {
            MusicManager.standardNextSong();
        }
    }

    public static boolean hasFailed() {
        return failsInARow > 5;
    }

    private static void standardNextSong() {
        if (OptionLib.MUSIC_SELECTION.c() == 0) {
            boolean djSuccess = MusicManager.nextTrackDJ();
            if (!djSuccess) {
                TannLog.error("Error finding playable dj song, playing something random");
                MusicManager.randomNewSong();
            }
        } else {
            MusicManager.randomNewSong();
        }
    }

    private static List<MusicData> getValidDjTracks() {
        ArrayList<MusicData> result = new ArrayList<MusicData>();
        MusicType mt = MusicManager.getCurrentMusicType();
        for (MusicData data : MusicManager.shufCop()) {
            if (Main.getSettings().isDisabledSong(data) || !Tann.contains(data.musicTypes, mt)) continue;
            result.add(data);
        }
        return result;
    }

    private static List<MusicData> getValidRandomTracks() {
        ArrayList<MusicData> result = new ArrayList<MusicData>();
        for (MusicData data : MusicManager.shufCop()) {
            if (Main.getSettings().isDisabledSong(data)) continue;
            result.add(data);
        }
        return result;
    }

    private static List<MusicData> shufCop() {
        ArrayList<MusicData> cpy = new ArrayList<MusicData>(dataList);
        Collections.shuffle(cpy);
        return cpy;
    }

    private static void newZoneNewSong() {
        boolean success = MusicManager.nextTrackDJ();
    }

    private static boolean nextTrackDJ() {
        if (MusicManager.isMusicDisabled()) {
            return false;
        }
        return MusicManager.playRandomRarity(MusicManager.getValidDjTracks());
    }

    private static boolean playRandomRarity(List<MusicData> tracks) {
        if (playing != null) {
            tracks.remove(MusicManager.playing.md);
        }
        if (fading != null) {
            tracks.remove(MusicManager.fading.md);
        }
        if (!playedList.isEmpty()) {
            tracks.remove(playedList.get(playedList.size() - 1));
        }
        float total = 0.0f;
        for (MusicData track : tracks) {
            total += track.getRarity(playedList);
        }
        int attempts = 5;
        if (Float.isNaN(total) || Float.isInfinite(total) || total == 0.0f) {
            TannLog.error("bad random rarity roll: " + total);
            return false;
        }
        for (int i = 0; i < attempts; ++i) {
            float roll = Tann.random(total);
            for (MusicData track : tracks) {
                if (!((roll -= track.getRarity(playedList)) <= 0.0f)) continue;
                boolean success = MusicManager.requestSong(track, false);
                if (success) {
                    return true;
                }
                TannLog.error("Failed to play song: " + track);
            }
        }
        return false;
    }

    private static MusicType getCurrentMusicType() {
        Zone z;
        Screen s = Main.getCurrentScreen();
        if (s instanceof TitleScreen) {
            return MusicType.Title;
        }
        if (s instanceof DungeonScreen && (z = Zone.guessFromLevel(((DungeonScreen)s).getDungeonContext().getCurrentMod20LevelNumber())) != null) {
            return z.getMusicType();
        }
        return MusicType.Mishap;
    }

    public static void userRequestNextSong() {
        MusicManager.standardNextSong();
    }

    public static void userRequestSkipBack() {
        if (fading != null) {
            fading.stop();
            fading = null;
        }
        if (playedList.size() == 0) {
            return;
        }
        MusicData toPlay = playedList.remove(playedList.size() - 1);
        MusicManager.requestSong(toPlay, true);
        if (playedList.size() == 0) {
            return;
        }
        playedList.remove(playedList.size() - 1);
    }

    public static void userRequestSkipForwards() {
        if (playing == null) {
            return;
        }
        playing.skipForwards();
    }

    private static void randomNewSong() {
        if (MusicManager.isMusicDisabled()) {
            return;
        }
        boolean success = MusicManager.playRandomRarity(MusicManager.getValidRandomTracks());
        if (!success) {
            TannLog.error("Failed to play random song, playing something random ignoring overrides");
            MusicManager.requestSong(Tann.random(dataList), true);
        }
    }

    public static MusicData getCurrentSongData(boolean current) {
        MusicFader mf;
        MusicFader musicFader = mf = current ? playing : fading;
        if (mf == null) {
            return null;
        }
        return mf.md;
    }

    public static String getCurrentSongTitle(boolean current) {
        MusicData p = MusicManager.getCurrentSongData(current);
        if (p == null) {
            return "none";
        }
        String[] spl = p.path.split("/");
        if (spl.length > 1) {
            String songName = spl[spl.length - 1];
            return Tann.makeEllipses(MusicFormat.getNiceName(songName), 99);
        }
        return "fail - p";
    }

    public static void clearStatics() {
        if (fading != null) {
            fading.stop();
        }
        if (playing != null) {
            playing.stop();
        }
        fading = null;
        playing = null;
        MusicCache.resetStatics();
    }

    public static void preloadMusicIfNecessary() {
        if (OptionLib.MUSIC_LOAD_TYPE.c() != 1 || MusicManager.isMusicDisabled()) {
            return;
        }
        for (MusicData musicDatum : dataList) {
            MusicCache.getOrLoad(musicDatum);
        }
    }

    public static float getCurrentSongPlayedAmt() {
        if (playing == null) {
            return 0.0f;
        }
        if (playing.isFinished()) {
            return 0.0f;
        }
        if (!MusicManager.playing.m.isPlaying()) {
            return 0.0f;
        }
        return MusicManager.playing.m.getPosition();
    }

    private static MusicData fromFader(MusicFader mf) {
        return mf.md;
    }

    public static MusicData getCurrentMusicData() {
        if (playing == null) {
            return null;
        }
        return MusicManager.fromFader(playing);
    }

    public static Musician fetchInefficiently(MusicData md) {
        for (Musician loadMusician : MusicBlob.loadMusicians(dataList)) {
            if (!loadMusician.songs.contains(md)) continue;
            return loadMusician;
        }
        return null;
    }

    static {
        playedList = new ArrayList<MusicData>();
        failsInARow = 0;
        waitingForThread = false;
        waitingBetweenSong = false;
    }
}

