/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test;

import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.VisualEffectType;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.TacticUtils;
import com.tann.dice.test.util.Test;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TestAbilities {
    @Test
    public static void testTacticAnim() {
        ArrayList<Tactic> bad = new ArrayList<Tactic>();
        for (Tactic tactic : TacticUtils.makeAll(false)) {
            Eff e = tactic.getBaseEffect();
            if (e.getType() == EffType.Or || e.isFriendly() || e.getVisual() != null && e.getVisual() != VisualEffectType.None) continue;
            bad.add(tactic);
        }
        Tann.assertBads(bad);
    }

    @Test
    public static void testAbilityFirstLetters() {
        ArrayList<Character> firstLetters = new ArrayList<Character>();
        List<Tactic> ts = TacticUtils.makeAll(false);
        Collections.sort(ts, TestAbilities.makeAlph());
        for (Tactic t : ts) {
            firstLetters.add(Character.valueOf(t.getTitle().toLowerCase().charAt(0)));
        }
        int size = firstLetters.size();
        Tann.uniquify(firstLetters);
        Tann.assertTrue("Abilities with same name: " + ts, size == firstLetters.size());
    }

    @Test
    public static void testAbilityCosts() {
        ArrayList<String> hashes = new ArrayList<String>();
        List<Tactic> ts = TacticUtils.makeAll(false);
        Collections.sort(ts, TestAbilities.makeAlph());
        for (Tactic t : ts) {
            hashes.add(t.debugGetTacticCost().describe());
        }
        ArrayList cpy = new ArrayList(hashes);
        Tann.uniquify(cpy);
        Tann.assertTrue("Abilities with same name: " + cpy + ":" + hashes, cpy.size() == hashes.size());
    }

    private static Comparator<? super Tactic> makeAlph() {
        return new Comparator<Tactic>(){

            @Override
            public int compare(Tactic o1, Tactic o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        };
    }
}

