/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test;

import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.die.side.EnSiBi;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonster;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.test.util.Slow;
import com.tann.dice.test.util.Test;
import com.tann.dice.util.DebugUtilsUseful;
import com.tann.dice.util.Tann;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TestPipe {
    @Test
    public static void modifierPipeValidation() {
        int amtPer = 100;
        ArrayList<String> bads = new ArrayList<String>();
        for (Pipe<Modifier> pipe : PipeMod.pipes) {
            if (pipe.isTransformative()) continue;
            List<Modifier> mods = pipe.examples(100);
            for (Modifier mod : mods) {
                Modifier n = pipe.get(mod.getName());
                if (n != null && n.getName().equalsIgnoreCase(mod.getName())) continue;
                bads.add(pipe.getClass().getSimpleName() + ":" + mod.getName());
            }
        }
        Tann.assertTrue("Should be no bads; " + bads, bads.isEmpty());
    }

    @Test
    @Slow
    public static void monsterPipeValidation() {
        int amtPer = 10;
        ArrayList<String> bads = new ArrayList<String>();
        for (Pipe<MonsterType> pipe : PipeMonster.pipes) {
            if (pipe.isTransformative()) continue;
            List<MonsterType> mods = pipe.examples(10);
            for (MonsterType mod : mods) {
                MonsterType n = PipeMonster.fetch(mod.getName());
                if (n != null && n.getName().equalsIgnoreCase(mod.getName())) continue;
                bads.add(pipe.getClass().getSimpleName() + ":" + mod.getName());
            }
        }
        Tann.assertTrue("Should be no bads; " + bads, bads.isEmpty());
    }

    @Test
    @Slow
    public static void heroPipeValidation() {
        int amtPer = 100;
        ArrayList<String> bads = new ArrayList<String>();
        for (Pipe<HeroType> pipe : PipeHero.pipes) {
            if (pipe.isTransformative()) continue;
            List<HeroType> mods = pipe.examples(100);
            for (HeroType mod : mods) {
                HeroType n = PipeHero.fetch(mod.getName());
                if (n != null && n.getName().equalsIgnoreCase(mod.getName())) continue;
                bads.add(pipe.getClass().getSimpleName() + ":" + mod.getName());
            }
        }
        Tann.assertTrue("Should be no bads; " + bads, bads.isEmpty());
    }

    @Test
    @Slow
    public static void itemPipeValidation() {
        int amtPer = 100;
        ArrayList<String> bads = new ArrayList<String>();
        for (Pipe<Item> pipe : PipeItem.pipes) {
            if (pipe.isTransformative()) continue;
            List<Item> mods = pipe.examples(100);
            for (Item mod : mods) {
                Item n = PipeItem.fetch(mod.getName());
                if (n != null && n.getName().equalsIgnoreCase(mod.getName())) continue;
                bads.add(pipe.getClass().getSimpleName() + ":" + mod.getName());
            }
        }
        Tann.assertTrue("Should be no bads; " + bads, bads.isEmpty());
    }

    @Test
    @Slow
    public static void pipePerformance() {
        int amtPer = 20;
        ArrayList<TP<Pipe, Long>> results = new ArrayList<TP<Pipe, Long>>();
        for (Pipe pipe : TestPipe.getForTest()) {
            List g;
            long t = System.currentTimeMillis();
            for (int genned = 0; genned < 20 && (g = pipe.examples(20)).size() != 0; genned += g.size()) {
            }
            long d = System.currentTimeMillis() - t;
            results.add(new TP<Pipe, Long>(pipe, d));
        }
        Collections.sort(results, new Comparator<TP<Pipe, Long>>(){

            @Override
            public int compare(TP<Pipe, Long> o1, TP<Pipe, Long> o2) {
                return Long.compare((Long)o2.b, (Long)o1.b);
            }
        });
        System.out.println(results);
        TP worst = (TP)results.get(0);
        int cutoffMS = 400;
        Tann.assertTrue("Should be none longer than cutoff: " + results, (Long)worst.b < 400L);
    }

    private static List<Pipe> getForTest() {
        List<Pipe> all = Pipe.makeAllPipes();
        for (int i = all.size() - 1; i >= 0; --i) {
            if (!all.get(i).isSlow()) continue;
            all.remove(i);
        }
        return all;
    }

    @Test
    public static void pipePerformanceUsedForGenerate() {
        int amtPer = 20;
        ArrayList<TP<Pipe, Long>> results = new ArrayList<TP<Pipe, Long>>();
        ArrayList<Pipe> bads = new ArrayList<Pipe>();
        for (Pipe pipe : TestPipe.getForTest()) {
            for (boolean wild : Tann.BOTH) {
                if (!pipe.canGenerate(wild)) continue;
                long t = System.currentTimeMillis();
                int made = 0;
                for (int i = 0; i < 20; ++i) {
                    Object g = pipe.generate(wild);
                    if (g == null) continue;
                    ++made;
                }
                if (made < 2) {
                    bads.add(pipe);
                }
                long d = System.currentTimeMillis() - t;
                results.add(new TP<Pipe, Long>(pipe, d));
            }
        }
        Collections.sort(results, new Comparator<TP<Pipe, Long>>(){

            @Override
            public int compare(TP<Pipe, Long> o1, TP<Pipe, Long> o2) {
                return Long.compare((Long)o2.b, (Long)o1.b);
            }
        });
        System.out.println(results);
        TP worst = (TP)results.get(0);
        int cutoffMS = 150;
        Tann.assertTrue("Should be no bads: " + bads, bads.isEmpty());
        Tann.assertTrue("Should be none longer than cutoff ms: " + results, (Long)worst.b < 150L);
    }

    @Test
    public static void testGeneratedMonsters() {
        int tests = 1000;
        ArrayList<MonsterType> fails = new ArrayList<MonsterType>();
        for (int i = 0; i < tests; ++i) {
            MonsterType mt = PipeMonster.makeGen();
            if (!mt.isMissingno() && !Float.isNaN(mt.getEffectiveHp()) && !Float.isNaN(mt.getOldSummonValue()) && !Float.isNaN(mt.getSummonValue())) continue;
            fails.add(mt);
        }
        Tann.assertTrue("" + fails, fails.isEmpty());
    }

    @Test
    public static void sidesAPI() {
        ArrayList<Object> bad = new ArrayList<Object>();
        for (Object s : EntSidesLib.getSizedSides(EntSize.reg)) {
            if (s instanceof EntSide || s instanceof EnSiBi) continue;
            bad.add(s);
        }
        Tann.assertBads(bad);
    }

    @Test
    @Slow
    public static void textmodDataIntegrity() {
        ArrayList<Pipe> bad = new ArrayList<Pipe>();
        String base = DebugUtilsUseful.getAllStrings();
        for (Pipe pipe : TestPipe.getForTest()) {
            pipe.examples(50);
            String test = DebugUtilsUseful.getAllStrings();
            if (test.equals(base)) continue;
            bad.add(pipe);
            base = test;
        }
        Tann.assertBads(bad);
    }
}

