/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.save.settings.option.Option;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.Flasher;
import com.tann.dice.util.ui.RadioCheckbox;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import java.util.Arrays;

public class Checkbox
extends Actor {
    boolean on;
    public static final int HORI_SIZE = 12;
    private Runnable toggleRunnable;

    private static int getSize() {
        return 12;
    }

    public Checkbox(boolean initial) {
        this(initial, Checkbox.getSize());
    }

    public Checkbox(boolean initial, int size) {
        this.on = initial;
        this.setSize(size, size);
    }

    private void toggle() {
        boolean bl = this.on = !this.on;
        if (this.toggleRunnable != null) {
            this.toggleRunnable.run();
        }
        Flasher f = new Flasher(this, this.on ? Colours.green : Colours.grey, 0.25f);
        f.setPosition(this.getX(), this.getY());
        this.getParent().addActor(f);
    }

    public void addToggleRunnable(Runnable runnable) {
        this.toggleRunnable = runnable;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Draw.fillActor(batch, this, Colours.dark, Colours.purple, 1);
        if (this.on) {
            batch.setColor(Colours.z_white);
            Draw.drawCentered(batch, Images.checkbox_tick_alone, (float)((int)(this.getX() + this.getWidth() / 2.0f)), (float)((int)(this.getY() + this.getHeight() / 2.0f)));
        }
        super.draw(batch, parentAlpha);
    }

    public boolean isOn() {
        return this.on;
    }

    public void force(boolean newValue) {
        this.on = newValue;
    }

    public Actor makeLabelledCheckbox(final String name, final String extraText, final String warnString) {
        Pixl p = new Pixl();
        p.actor(this).gap(this instanceof RadioCheckbox ? 1 : 3).text("[text]" + name);
        Group a = p.pix();
        a.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                if (!Checkbox.this.warn(name, warnString)) {
                    Checkbox.this.toggle();
                }
                return true;
            }

            @Override
            public boolean info(int button, float x, float y) {
                return Option.showExtraInfo(name, extraText);
            }
        });
        return a;
    }

    public Actor makeLabelledCheckbox(String name, String extraText) {
        return this.makeLabelledCheckbox(name, extraText, null);
    }

    public void addDefaultToggleListener() {
        this.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Checkbox.this.toggle();
                Sounds.playSound(Sounds.pipSmall);
                return true;
            }
        });
    }

    private boolean warn(String checkboxName, String warn) {
        if (warn == null) {
            return false;
        }
        String s = "Are you sure you want to " + (!this.on ? "enable" : "disable") + " " + checkboxName + "? " + warn;
        Group a = new Pixl().text(s, (int)((float)Main.width * 0.7f)).pix();
        ChoiceDialog cd = new ChoiceDialog(null, Arrays.asList(a), ChoiceDialog.ChoiceNames.YesCancel, new Runnable(){

            @Override
            public void run() {
                Checkbox.this.toggle();
                Main.getCurrentScreen().pop(ChoiceDialog.class);
            }
        }, new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pop);
                Main.getCurrentScreen().pop(ChoiceDialog.class);
            }
        });
        Sounds.playSound(Sounds.pip);
        Main.getCurrentScreen().push(cd, true, true, false, 0.9f);
        Tann.center(cd);
        return true;
    }
}

