/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.tann.dice.Main;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.ui.ClipboardUtils;

public class TextInput
extends Group {
    private static final float CARET_FLASH_SPEED = 4.5f;
    private static final float CARET_FORCE_DURATION = 0.3f;
    public static final int MAX_LENGTH = 2000;
    private static final int MAX_CHARS_TO_DISPLAY = 200;
    String text = "";
    TannFont font = TannFont.font;
    int caretIndex = 0;
    Input.TextInputListener listener;
    static final int HOME_END = 9999999;
    float forceCaret;

    public TextInput(Input.TextInputListener listener) {
        this.setSize(Math.min(190.0f, (float)Main.width * 0.8f), TannFont.font.getHeight());
        this.listener = listener;
        this.setTransform(false);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.moveCaretToEnd();
    }

    private void moveCaretToEnd() {
        this.caretIndex = this.text.length();
    }

    @Override
    public boolean notify(Event event, boolean capture) {
        if (!(event instanceof InputEvent)) {
            return false;
        }
        InputEvent event1 = (InputEvent)event;
        boolean ctrl = Gdx.input.isKeyPressed(129);
        if (event1.getType() == InputEvent.Type.keyDown) {
            int kc = event1.getKeyCode();
            switch (kc) {
                case 50: {
                    String clip;
                    if (!ctrl || (clip = ClipboardUtils.pasteSafer()) == null) break;
                    for (char c : clip.toCharArray()) {
                        this.addChar(c);
                    }
                    break;
                }
                case 31: {
                    if (this.text.length() <= 0 || !ctrl) break;
                    ClipboardUtils.copyWithSoundAndToast(this.text);
                    break;
                }
                case 111: {
                    Main.getCurrentScreen().popSingleMedium();
                    break;
                }
                case 21: {
                    this.moveCaret(-1);
                    break;
                }
                case 22: {
                    this.moveCaret(1);
                    break;
                }
                case 3: {
                    this.moveCaret(-9999999);
                    break;
                }
                case 123: {
                    this.moveCaret(9999999);
                }
            }
        }
        if (event1.getType() == InputEvent.Type.keyTyped) {
            char c = event1.getCharacter();
            switch (c) {
                case '\b': {
                    if (Gdx.input.isKeyPressed(129)) {
                        this.deleteChars(99999);
                        break;
                    }
                    this.deleteChars(1);
                    break;
                }
                case '\u007f': {
                    if (this.caretIndex >= this.text.length()) break;
                    this.text = this.text.substring(0, this.caretIndex) + this.text.substring(this.caretIndex + 1, this.text.length());
                    this.forceShowCaret();
                    break;
                }
                case '\n': {
                    Main.getCurrentScreen().popSingleMedium();
                    this.listener.input(this.text);
                    break;
                }
                default: {
                    this.addChar(c);
                }
            }
            event1.cancel();
        }
        event1.cancel();
        event1.stop();
        return true;
    }

    private void deleteChars(int amt) {
        this.text = this.text.substring(0, Math.max(0, this.caretIndex - amt)) + this.text.substring(this.caretIndex, this.text.length());
        this.moveCaret(-amt);
        this.forceShowCaret();
    }

    private void moveCaret(int delta) {
        this.caretIndex += delta;
        this.caretIndex = Math.max(0, Math.min(this.text.length(), this.caretIndex));
        this.forceShowCaret();
    }

    private void forceShowCaret() {
        this.forceCaret = 0.3f;
    }

    private void addChar(char c) {
        if (this.font.hasChar(c) && this.text.length() < 2000) {
            this.text = this.text.substring(0, this.caretIndex) + c + this.text.substring(this.caretIndex, this.text.length());
            ++this.caretIndex;
            this.forceShowCaret();
        }
    }

    @Override
    public void act(float delta) {
        this.forceCaret -= delta;
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(Colours.text);
        this.font.drawString(batch, this.text.substring(0, Math.min(200, this.text.length())), this.getX(), this.getY());
        if (Math.sin(Main.secs * 4.5f) > 0.0 && this.text.length() < 200 || this.forceCaret > 0.0f) {
            int w = this.font.getWidth(this.text.substring(0, this.caretIndex));
            batch.setColor(Colours.grey);
            Draw.fillRectangle(batch, this.getX() + (float)w, this.getY(), 1.0f, 8.0f);
        }
        super.draw(batch, parentAlpha);
    }

    public String getText() {
        return this.text;
    }

    public void clearTextInput() {
        this.text = "";
        this.moveCaretToEnd();
    }
}

