#ifdef GL_ES 
#define LOWP lowp
#define MED mediump
#define HIGH highp
precision highp float;
#else
#define MED
#define LOWP
#define HIGH
#endif

varying vec4 v_color;  
varying vec2 v_texCoords;  
uniform float u_alpha;
uniform float u_random;

uniform sampler2D u_texture;  

uniform vec4 u_noiseBounds;
float noise(vec2 loc) {
  vec2 bigLoc = mod(loc, u_noiseBounds.ba*2.0);
  vec2 smallLoc = mod(loc, u_noiseBounds.ba*1.0);
  vec2 quadrants = bigLoc/u_noiseBounds.ba;
  int index = int(quadrants.x) + int(quadrants.y)*2;
  vec4 col = texture2D(u_texture, u_noiseBounds.xy + smallLoc.xy);
  return col[index];
}
float noise(vec2 loc, int octaves) {
  float val = 0.5;
  for(int i=0;i<octaves;i++) {
    float power = pow(2.0, float(i));
    val += (noise(loc * power)-0.5)/power;
  }
  return val;
}

void main(){              
  vec4 col = v_color * texture2D(u_texture, v_texCoords);
  float noiseVal = noise(gl_FragCoord.xy*0.003+u_random*1000.0);
  if(noiseVal < u_alpha) {
    col.a=0.0;
  }
  float colAlpha = pow(u_alpha, 1.9);
  col.rgb = col.rgb*(1.0-colAlpha) + vec3(.2, .8, .3)*colAlpha;
  gl_FragColor = col;
}

